# scrobble_delay.py
import sys
import os
import xbmc
import xbmcaddon
import urllib.parse
import json

try:
    if len(sys.argv) < 3:
        raise ValueError("Chybí argument cesty k addonu.")
   
    __addon_path__ = urllib.parse.unquote_plus(sys.argv[2])
    scrobble_lib_path = os.path.join(__addon_path__, 'resources', 'lib')
    sys.path.append(scrobble_lib_path)
   
    from scrobble import scrobble_start, get_item_data
    xbmc.log(f'########## SCROBBLE DELAY: Import OK, cesta: {scrobble_lib_path} ##########', xbmc.LOGINFO)
   
except Exception as e:
    xbmc.log(f'########## SCROBBLE DELAY: CHYBA IMPORTU: {e} ##########', xbmc.LOGERROR)
    sys.exit(1)

MAX_WAIT_SECONDS = 5
for i in range(MAX_WAIT_SECONDS):
    title = xbmc.getInfoLabel('Player.Title')
    if title and title not in ('Player.Title', ''):
        xbmc.log(f'########## SCROBBLE DELAY: Title: {title} ##########', xbmc.LOGINFO)
       
        payload = get_item_data(title)
        if payload:
            try:
                addon = xbmcaddon.Addon('plugin.video.mmirousek')
                
                # 1. Ulož payload
                addon.setSetting('trakt_last_payload', json.dumps(payload))
                
                # 2. ZAMKNI – už se nebude přepisovat
                addon.setSetting('trakt_payload_locked', 'true')
                
                # 3. Vyčisti cache (bez ReloadSkin)
                xbmc.executebuiltin('UpdateAddonRepos')
                
                xbmc.log('########## SCROBBLE DELAY: Payload ULOŽEN + ZAMKNUT ##########', xbmc.LOGINFO)
            except Exception as e:
                xbmc.log(f'########## SCROBBLE DELAY: CHYBA ULOŽENÍ: {e} ##########', xbmc.LOGERROR)       
        scrobble_start(title)
        sys.exit(0)
   
    xbmc.sleep(1000)

xbmc.log('########## SCROBBLE DELAY: Title nenalezen po 5s ##########', xbmc.LOGERROR)