# resources/lib/context_trakt.py
import xbmc
import xbmcgui
import xbmcaddon
import json
import requests
import sys

# Import z trakt_module – používáme centralizované funkce
from resources.lib.trakt.trakt_service import get_trakt_token, get_trakt_headers

ADDON = xbmcaddon.Addon('plugin.video.mmirousek')
_ = ADDON.getLocalizedString

def build_item():
    dbtype = xbmc.getInfoLabel('ListItem.DBTYPE')
    title = xbmc.getInfoLabel('ListItem.Title') or xbmc.getInfoLabel('ListItem.Label')
    year = xbmc.getInfoLabel('ListItem.Year')
    imdb = xbmc.getInfoLabel('ListItem.IMDBNumber')
    tmdb = xbmc.getInfoLabel('ListItem.Property(tmdb_id)') or xbmc.getInfoLabel('ListItem.UniqueID(tmdb)')
    tvdb = xbmc.getInfoLabel('ListItem.UniqueID(tvdb)')
    season = xbmc.getInfoLabel('ListItem.Season')
    episode = xbmc.getInfoLabel('ListItem.Episode')

    if not title or dbtype not in ['movie', 'episode', 'tvshow']:
        return None

    item = {"title": title}
    if year and year.isdigit():
        item["year"] = int(year)

    ids = {}
    if imdb: ids["imdb"] = imdb
    if tmdb and tmdb.isdigit(): ids["tmdb"] = int(tmdb)
    if tvdb and tvdb.isdigit(): ids["tvdb"] = int(tvdb)
    if ids: item["ids"] = ids

    if dbtype == "movie":
        return {"movies": [item]}
    elif dbtype == "tvshow":
        return {"shows": [item]}
    elif dbtype == "episode":
        show_title = xbmc.getInfoLabel('ListItem.TVShowTitle') or title
        show_item = {"title": show_title}
        if ids: show_item["ids"] = ids
        return {
            "episodes": [{
                "season": int(season) if season and season.isdigit() else 1,
                "number": int(episode) if episode and episode.isdigit() else 1,
                "shows": [show_item]
            }]
        }
    return None

def add_to_watchlist():
    token = get_trakt_token()
    if not token:
        xbmcgui.Dialog().ok("Trakt", "Nejste přihlášeni k Trakt.")
        return

    media = build_item()
    if not media:
        xbmcgui.Dialog().ok("Chyba", "Nelze identifikovat položku.")
        return

    headers = get_trakt_headers()
    if not headers:
        xbmc.log("Trakt: Nejsi přihlášený.", xbmc.LOGWARNING)
        return

    try:
        response = requests.post(
            'https://api.trakt.tv/sync/watchlist',
            json=media,
            headers=headers,
            timeout=10
        )
        if response.status_code == 201:
            xbmcgui.Dialog().notification("Trakt", "Přidáno do Watchlist", xbmcgui.NOTIFICATION_INFO, 3000)
            xbmc.executebuiltin('Container.Refresh')
        elif response.status_code == 401:
            xbmcgui.Dialog().ok("Trakt", "Autorizace selhala. Znovu přihlaste.")
        else:
            error = response.json().get('error_description', 'Neznámá chyba')
            xbmcgui.Dialog().ok("Chyba", error)
    except Exception as e:
        xbmcgui.Dialog().ok("Chyba", str(e))

if __name__ == '__main__':
    action = sys.argv[1] if len(sys.argv) > 1 else ""
    if action == "add_to_watchlist":
        add_to_watchlist()