
# -*- coding: utf-8 -*-
# Module: default
# Author: cache-sk
# Created on: 10.5.2020
# License: AGPL v.3 https://www.gnu.org/licenses/agpl-3.0.html
import io
import os
import sys
import xbmc
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmcvfs
import requests.cookies
from xml.etree import ElementTree as ET
import hashlib
from md5crypt import md5crypt
import traceback
import json
import unidecode
import re
import zipfile
import uuid
from resources.lib.series import series_manager
from resources.lib import local_history  # Ujistěte se, že toto je nahoře mezi importy
from resources.lib.tvprogram import TVProgram
from resources.lib.webshare_auth import WebshareClient
from resources.lib.tmdb import tmdb_utils
from resources.lib.down.download_manager import download as _download_ext
from resources.lib.utils.ui_utils import make_static_item, pick_icon, toggle_watchlist
from resources.lib.down.offline_movie import list_watchlist_items
download = _download_ext

from resources.lib.search_ui import search, loadsearch, storesearch, removesearch, dosearch, show_search_dialog
from resources.lib.series.series_ui import (
    series_menu, series_search, series_detail, series_season,
    series_remove, series_remove_season, series_remove_episode, series_refresh_smart
)
# V yawsp.py, hned po ostatních importech (např. po importu series_ui):
from resources.lib.trakt.trakt_service import TraktAPI 
from resources.lib.webshare_auth import WebshareClient
from resources.lib.series.series_actions import series_mark_season, series_mark_episode, csfd_lookup_enhanced

try:
    from urllib import urlencode
    from urlparse import parse_qsl, urlparse
except ImportError:
    from urllib.parse import urlencode
    from urllib.parse import parse_qsl, urlparse
try:
    from xbmc import translatePath
except ImportError:
    from xbmcvfs import translatePath
ADDON_ID = 'plugin.video.mmirousek_v2'  # <--- TOTO JE NOVÁ LINIE PRO OPRAVU CHYBY!
ADDON = xbmcaddon.Addon(ADDON_ID)  # Původně ADDON = xbmcaddon.Addon()
ADDON_NAME = ADDON.getAddonInfo('name')
BASE = 'https://webshare.cz'
API = BASE + '/api/'
UA = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36"
HEADERS = {'User-Agent': UA, 'Referer':BASE}
REALM = ':Webshare:'
CATEGORIES = ['','video','images','audio','archives','docs','adult']
SORTS = ['','recent','rating','largest','smallest']
SEARCH_HISTORY = 'search_history'
NONE_WHAT = '%#NONE#%'
BACKUP_DB = 'D1iIcURxlR'
_url = sys.argv[0]
_handle = int(sys.argv[1])
_addon = xbmcaddon.Addon('plugin.video.mmirousek_v2')
_session = requests.Session()
_session.headers.update(HEADERS)
_profile = translatePath( _addon.getAddonInfo('profile'))
_WS = WebshareClient(ADDON_ID)

# Pevné umístění EPG do profilu doplňku
EPG_DIR = os.path.join(_profile, "epg")
if not os.path.isdir(EPG_DIR):
    os.makedirs(EPG_DIR, exist_ok=True)
EPG_JSON = os.path.join(EPG_DIR, "epg_all.json")
# Import updateru (náš nový modul)
from resources.lib.epg_updater import ensure_default_channels, update_epg
# Inicializace modulu TVProgram s pevnou cestou k EPG
use_colors = True
try:
    use_colors = (_addon.getSetting('epg_color_tags') == 'true')
except Exception:
    pass
TV = TVProgram(
    handle=_handle,
    base_url=_url,
    addon_id=ADDON_ID,
    addon_path=translatePath(_addon.getAddonInfo("path")),
    addon_data_path=_profile,
    json_file=EPG_JSON,
    route_prefix="tvprog",
    use_colors=use_colors
)
# === AUTOMATICKÝ TRAKT REFRESH – JEN JEDNOU ZA RELACI KODI ===
win = xbmcgui.Window(10000)
if win.getProperty('mm_trakt_auto_refresh_done') != '1':
    xbmc.log("[mmirousek_v2] Spouštím auto-refresh Trakt tokenu (první start v relaci)", xbmc.LOGINFO)
    try:
        from resources.lib.trakt.trakt_module import maybe_refresh_on_start
        maybe_refresh_on_start(threshold_hours=12)
    except Exception as e:
        xbmc.log(f"[TraktAutoRefresh] Selhalo: {e}", xbmc.LOGERROR)
    
    # Označíme, že jsme to už udělali v této relaci
    win.setProperty('mm_trakt_auto_refresh_done', '1')
# ================================================

# Pomocná funkce: po refreshi cache otevře stránku "Pokrok sledování"
def _update_progress_view():
    try:
        # Default: jen rozkoukané; uprav podle potřeby nebo si předej parametry z kontextu
        url = get_url(
            action='trakt_shows_progress',
            page=1, limit=30,
            mode='cache',
            only_incomplete='true'
        )
        xbmc.executebuiltin(f'Container.Update({url})')
    except Exception as e:
        xbmc.log(f"[Router] update progress view failed: {e}", xbmc.LOGERROR)
        xbmc.executebuiltin('Container.Refresh')

def _tmdb():
    return __import__('resources.lib.tmdb.tmdb_series_detail', fromlist=['*'])

def _vip_start_popup_if_needed(threshold_days=11):
    """
    Nenásilné VIP upozornění při startu:
    - zobrazí se jen jednou za relaci (session guard),
    - provede se jen pokud už JE k dispozici token (uživatel dříve přihlášen),
    - nevyžádá si login (guest-first).
    """
    try:
        # Session guard: jen jednou za relaci
        win = xbmcgui.Window(10000)
        if win.getProperty('mm_ws_vip_start_info_shown') == '1':
            return
        # Máme už uložený token? (nepřihlašujeme)
        existing_token = _addon.getSetting('token') or ''
        if not existing_token:
            # Guest → nedělej nic (ať se popup nespouští opakovaně)
            win.setProperty('mm_ws_vip_start_info_shown', '1')
            return
        # Přímé volání /api/user_data s existujícím tokenem (bez revalidate)
        resp = api('user_data', {'wst': existing_token})
        try:
            xml = ET.fromstring(resp.content)
        except Exception:
            win.setProperty('mm_ws_vip_start_info_shown', '1')
            return
        status_el = xml.find('status')
        if status_el is None or status_el.text != 'OK':
            win.setProperty('mm_ws_vip_start_info_shown', '1')
            return
        vip_days_txt = (xml.findtext('vip_days', '') or '').strip()
        vip_until = (xml.findtext('vip_until', '') or '').strip()
        try:
            vip_days = int(vip_days_txt) if vip_days_txt != '' else 0
        except Exception:
            vip_days = 0
        if vip_days < threshold_days:
            if vip_days <= 0:
                msg = "VIP není aktivní."
            else:
                msg = f"VIP: zbývá {vip_days} dní" + (f" • do {vip_until}" if vip_until else "")
            xbmcgui.Dialog().notification(ADDON_NAME, msg, xbmcgui.NOTIFICATION_INFO, 3500)
        # Označ, že popup byl v této relaci vyhodnocen (a případně zobrazen)
        win.setProperty('mm_ws_vip_start_info_shown', '1')
    except Exception as e:
        xbmc.log(f"[VIP START POPUP] skipped due to error: {e}", xbmc.LOGWARNING)


from datetime import datetime, timedelta

def ensure_epg_fresh():
    """
    Při vstupu do TV Programu zajistí:
    - epg_all.json existuje (jinak nabídne stažení),
    - pokud je starší než nastavený interval (default 72h), nabídne aktualizaci.
    """
    try:
        ensure_default_channels(EPG_DIR)
    except Exception as e:
        xbmc.log(f"[TVProgram] CHYBA při přípravě kanálů: {e}", xbmc.LOGERROR)

    need_update = False
    if not os.path.exists(EPG_JSON):
        need_update = True
    else:
        try:
            mtime = datetime.fromtimestamp(os.path.getmtime(EPG_JSON))
            now = datetime.now()
            # ✅ Nová logika: pokud je soubor starší než 72 hodin
            if mtime < (now - timedelta(hours=72)):
                need_update = True
        except Exception:
            need_update = True

    if not need_update:
        return

    dlg = xbmcgui.Dialog()
    if not dlg.yesno("TV Program", "Aktualizovat EPG (dnes + 5 dnů) čekej,trvá to", "Operaci lze kdykoli zrušit."):
        return

    progress = xbmcgui.DialogProgress()
    progress.create("TV Program", "Aktualizuji EPG…")
    try:
        def on_progress(pct, line1="", line2=""):
            try:
                progress.update(int(pct), line1, line2)
            except Exception:
                pass

        def is_canceled():
            try:
                return progress.iscanceled()
            except Exception:
                return False

        update_epg(EPG_DIR, on_progress=on_progress, is_canceled=is_canceled,
                   days_forward=3, start_offset=0)
        progress.close()
        xbmcgui.Dialog().notification(ADDON_NAME, "EPG aktualizováno", xbmcgui.NOTIFICATION_INFO, 3000)
    except Exception as e:
        try:
            progress.close()
        except Exception:
            pass
        xbmcgui.Dialog().notification(ADDON_NAME, f"Chyba EPG: {e}", xbmcgui.NOTIFICATION_ERROR, 5000)
        

try:
    _profile = _profile.decode("utf-8")
except:
    pass
# def get_url(**kwargs):
#     return '{0}?{1}'.format(_url, urlencode(kwargs, 'utf-8'))
def get_url(**kwargs):
    # PŮVODNÍ: urlencode(kwargs, 'utf-8') – druhý poziční parametr je 'doseq'
    # OPRAVA: použij pojmenovaný parametr encoding='utf-8'
    return '{0}?{1}'.format(_url, urlencode(kwargs, encoding='utf-8'))

# Forwardery na klienta – signatury držíme stejné, aby kód níže nemusel měnit nic.
def api(fnct, data):
    return _WS.api(fnct, data)
def login():
    return _WS.login()
def revalidate():
    return _WS.revalidate()
def getlink(ident, wst=None, dtype='video_stream'):
    # wst se už tahá uvnitř klienta, necháme parametr kvůli kompatibilitě
    return _WS.getlink(ident, dtype=dtype)
def is_ok(xml):
    status = xml.find('status').text
    return status == 'OK'
def popinfo(message, heading=_addon.getAddonInfo('name'), icon=xbmcgui.NOTIFICATION_INFO, time=3000, sound=False): #NOTIFICATION_WARNING NOTIFICATION_ERROR
    xbmcgui.Dialog().notification(heading, message, icon, time, sound=sound)

# --- Helper pro TMDb -> Trakt ID lookup ---

def _resolve_trakt_id_and_call(action_type, p):
    LOG_PREFIX = "mm.hlavni_router"
    media_type = (p.get('media_type') or 'movies').strip()
    ident = (p.get('id') or '').strip()
    title = p.get('title', '')

    # Bezpečné převody na int
    try:
        page = int(p.get('page', 1))
    except Exception:
        page = 1
    try:
        limit = int(p.get('limit', 30))
    except Exception:
        limit = 30

    # Pokud ident je TMDb ID (číslo), proveď lookup na Trakt
    if ident.isdigit():
        try:
            from resources.lib.trakt.trakt_service import TraktAPI
            api = TraktAPI()
            search_type = 'movie' if media_type == 'movies' else 'show'
            search = api.get(f"search/tmdb/{ident}", params={'type': search_type}, auth=False, cache_ttl=0)
            if search and isinstance(search, list):
                obj = (search[0].get(search_type) or {})
                ids = obj.get('ids') or {}
                ident = ids.get('slug') or str(ids.get('trakt') or '')
        except Exception as e:
            xbmc.log(f"[{LOG_PREFIX}] TMDb→Trakt lookup failed: {e}", xbmc.LOGWARNING)

    if not ident:
        xbmcgui.Dialog().notification('Trakt', 'Nelze načíst Trakt ID pro tento titul.', xbmcgui.NOTIFICATION_WARNING)
        xbmcplugin.endOfDirectory(_handle, succeeded=False)
        return

    try:
        from resources.lib.trakt.trakt_module import TraktMenu
        menu = TraktMenu(_handle, _addon)
        if action_type == 'people':
            menu.show_people(media_type, ident, title)
        elif action_type == 'related':
            menu.show_related(media_type, ident, page, limit)
    except Exception as e:
        xbmc.log(f"[{LOG_PREFIX}] resolver call failed: {e}", xbmc.LOGERROR)
        xbmcgui.Dialog().notification(_addon.getAddonInfo('name'), "Chyba akce.", xbmcgui.NOTIFICATION_ERROR, 3000)
        xbmcplugin.endOfDirectory(_handle, succeeded=False)


def todict(xml, skip=[]):
    result = {}
    for e in xml:
        if e.tag not in skip:
            value = e.text if len(list(e)) == 0 else todict(e,skip)
            if e.tag in result:
                if isinstance(result[e.tag], list):
                    result[e.tag].append(value)
                else:
                    result[e.tag] = [result[e.tag],value]
            else:
                result[e.tag] = value
    #result = {e.tag:(e.text if len(list(e)) == 0 else todict(e,skip)) for e in xml if e.tag not in skip}
    return result

def sizelize(txtsize, units=['B','KB','MB','GB']):
    if txtsize:
        size = float(txtsize)
        if size < 1024:
            size = str(size) + units[0]
        else:
            size = size / 1024
            if size < 1024:
                size = str(int(round(size))) + units[1]
            else:
                size = size / 1024
                if size < 1024:
                    size = str(round(size,2)) + units[2]
                else:
                    size = size / 1024
                    size = str(round(size,2)) + units[3]
        return size
    return str(txtsize)
def labelize(file):
    if 'size' in file:
        size = sizelize(file['size'])
    elif 'sizelized' in file:
        size = file['sizelized']
    else:
        size = '?'
    label = file['name'] + ' (' + size + ')'
    return label

def tolistitem(file, addcommands=[]):
    label = labelize(file)
    listitem = xbmcgui.ListItem(label=label)
    if 'img' in file:
        listitem.setArt({'thumb': file['img']})
    listitem.setInfo('video', {'title': label})
    listitem.setProperty('IsPlayable', 'true')

    # Použij pouze dodané příkazy a přepiš defaultní
    if addcommands:
        listitem.addContextMenuItems(addcommands, replaceItems=True)
    return listitem

def ask(what):
    if what is None:
        what = ''
    kb = xbmc.Keyboard(what, _addon.getLocalizedString(30007))
    kb.doModal() # Onscreen keyboard appears
    if kb.isConfirmed():
        return kb.getText() # User input
    return None

# ----------------------------------------------------------------------------------------------------
def queue(params):
    xbmcplugin.setPluginCategory(_handle, _addon.getAddonInfo('name') + " \\ " + _addon.getLocalizedString(30202))
    token = revalidate()
    updateListing=False
    if 'dequeue' in params:
        response = api('dequeue_file',{'ident':params['dequeue'],'wst':token})
        xml = ET.fromstring(response.content)
        if is_ok(xml):
            popinfo(_addon.getLocalizedString(30106))
        else:
            popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)
        updateListing=True
    response = api('queue',{'wst':token})
    xml = ET.fromstring(response.content)
    if is_ok(xml):
        for file in xml.iter('file'):
            item = todict(file)
            commands = []
            commands.append(( _addon.getLocalizedString(30215), 'Container.Update(' + get_url(action='queue',dequeue=item['ident']) + ')' ))
            listitem = tolistitem(item,commands)
            xbmcplugin.addDirectoryItem(_handle, get_url(action='play',ident=item['ident'],name=item['name']), listitem, False)
    else:
        popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)
    xbmcplugin.endOfDirectory(_handle,updateListing=updateListing)

def toqueue(ident,token):
    response = api('queue_file',{'ident':ident,'wst':token})
    xml = ET.fromstring(response.content)
    if is_ok(xml):
        popinfo(_addon.getLocalizedString(30105))
    else:
        popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)

def history(params):
    xbmcplugin.setPluginCategory(_handle, _addon.getAddonInfo('name') + " \\ " + _addon.getLocalizedString(30203))
    token = revalidate()
    updateListing=False
    if 'remove' in params:
        remove = params['remove']
        updateListing=True
        response = api('history',{'wst':token})
        xml = ET.fromstring(response.content)
        ids = []
        if is_ok(xml):
            for file in xml.iter('file'):
                if remove == file.find('ident').text:
                    ids.append(file.find('download_id').text)
        else:
            popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)
        if ids:
            response = api('clear_history',{'ids[]':ids,'wst':token})
            xml = ET.fromstring(response.content)
            if is_ok(xml):
                popinfo(_addon.getLocalizedString(30106))
            else:
                popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)
    if 'toqueue' in params:
        toqueue(params['toqueue'],token)
        updateListing=True
    response = api('history',{'wst':token})
    xml = ET.fromstring(response.content)
    if is_ok(xml):
        for file in xml.iter('file'):
            item = todict(file)
            commands = []
            commands.append(( _addon.getLocalizedString(30215), 'Container.Update(' + get_url(action='queue',dequeue=item['ident']) + ')' ))
            commands.append(( _addon.getLocalizedString(30213), 'Container.Update(' + get_url(action='history',remove=item['ident']) + ')' ))
            listitem = tolistitem({'ident':item.get('ident'),'name':item.get('name'),'sizelized':item.get('size')},commands)
            xbmcplugin.addDirectoryItem(_handle, get_url(action='play',ident=item.get('ident'),name=item.get('name')), listitem, False)
    else:
        popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)
    xbmcplugin.endOfDirectory(_handle,updateListing=updateListing)

def settings(params):
    _addon.openSettings()

def infonize(info, key, f=None, prefix=' - ', suffix='\n', showkey=True):
    text = ''
    if key in info and info[key]:
        if showkey:
            text += prefix + key + ': '
        else:
            text += prefix
        if f is None:
            text += info[key]
        else:
            text += f(info[key])
        text += suffix
    return text

def fpsize(txtfps):
    if txtfps:
        fps = float(txtfps)
        return str(round(fps,2)) + 'fps'
    return str(txtfps)

# V souboru yawsp.py
def info(params):
    # Zkontrolujeme, zda ident vypadá jako IMDb ID (začíná na 'tt')
    ident = params.get('ident', '')
    if ident.startswith('tt'):
        # Toto je volání z Trakt.tv. Místo zobrazení info dialogu
        # spustíme Webshare vyhledávání pro titul filmu/seriálu.
        if 'title' in params:
            # Vytvoříme nové parametry pro stávající funkci search(params)
            search_params = {
                'action': 'search',
                'q': params['title'], # Použijeme název jako dotaz
            }
            # Tato akce nahradí stávající adresář výsledky Webshare
            search(search_params)
            return
        else:
            # Nelze vyhledávat, pokud chybí title
            popinfo('Nelze vyhledat Webshare: Chybí název.', icon=xbmcgui.NOTIFICATION_WARNING)
            xbmcplugin.endOfDirectory(_handle)
            return

    # PŮVODNÍ LOGIKA PRO WEBSHARE ID
    token = revalidate()
    response = api('file_info',{'ident':params['ident'],'wst':token})
    xml = ET.fromstring(response.content)
    if is_ok(xml):
        info = todict(xml)
        text = ''
        text += infonize(info, 'name', showkey=False)
        text += infonize(info, 'upload_date')
        text += infonize(info, 'size', sizelize)
        text += infonize(info, 'length', showkey=False)
        text += infonize(info, 'rating')
        text += infonize(info, 'views')
        text += infonize(info, 'description')
        text += infonize(info, 'bitrate', lambda x:sizelize(x,['bps','Kbps','Mbps','Gbps']))
        if 'video' in info and 'stream' in info['video']:
            streams = info['video']['stream']
            if isinstance(streams, dict):
                streams = [streams]
            for stream in streams:
                text += 'Video stream: '
                text += infonize(stream, 'width', showkey=False, suffix='')
                text += infonize(stream, 'height', showkey=False, prefix='x', suffix='')
                text += infonize(stream,'format', showkey=False, prefix=', ', suffix='')
                text += infonize(stream,'fps', fpsize, showkey=False, prefix=', ', suffix='')
                text += '\n'
        if 'audio' in info and 'stream' in info['audio']:
            streams = info['audio']['stream']
            if isinstance(streams, dict):
                streams = [streams]
            for stream in streams:
                text += 'Audio stream: '
                text += infonize(stream, 'format', showkey=False, suffix='')
                text += infonize(stream,'channels', prefix=', ', showkey=False, suffix='')
                text += infonize(stream,'bitrate', lambda x:sizelize(x,['bps','Kbps','Mbps','Gbps']), prefix=', ', showkey=False, suffix='')
                text += '\n'
        text += infonize(info, 'removed', lambda x:'Yes' if x=='1' else 'No')
        xbmcgui.Dialog().textviewer(_addon.getAddonInfo('name'), text)
    else:
        # Původní chyba
        popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)
        # DŮLEŽITÁ OPRAVA: Ukončení adresáře je nutné vždy,
        # pokud je funkce volána jako 'isFolder=True', ať už se zobrazil dialog nebo ne.
        xbmcplugin.endOfDirectory(_handle)

def play(params):
    """
    Režimy:
    1) Výběr streamu epizody (select=1 + series_name/season/episode):
        - Offline kontrola (dfolder) → pokud je soubor na disku, hraje rovnou.
        - Jinak 2‑řádkový výběr kurátorovaných streamů → nastaví ident a padá do režimu (2).
    2) Klasické přehrání podle ident (film/epizoda):
        - revalidate → getlink(ident) → Kodi 'pipe headers' ve standardní podobě URL|Header1=...&Header2=...
        - robustní logování + fallback Player().play(...), když se setResolvedUrl nechytí.
    """
    try:
        xbmc.log(f"[PLAY] params IN: {params}", xbmc.LOGDEBUG)
    except Exception:
        pass
        # --------------------------------------------------
    # DEBUG: Ověření, zda máme tmdb_id a mediatype v params
    # --------------------------------------------------
    tmdb_id_debug = params.get('tmdb_id')
    mediatype_debug = params.get('mediatype')
    xbmc.log(f"[DEBUG PLAY] Přijaté parametry v play(): tmdb_id={tmdb_id_debug}, mediatype={mediatype_debug}, ident={params.get('ident')}, name='{params.get('name')}'", xbmc.LOGINFO)
    # --------------------------------------------------
    import os
    import re
    from urllib.parse import urlencode

    # PŘEDPOKLAD: tyto proměnné jsou definovány v modulu (např. v yawsp.py)
    # _handle, ADDON, series_manager, _addon, _profile, UA, BASE, popinfo, revalidate, getlink

    def _clean_filename(name: str) -> str:
        if not name:
            return "download"
        safe = re.sub(r'[\:\\/*?"<>|]', '_', str(name))
        return safe.strip() or "download"

    def _path_exists(p: str) -> bool:
        try:
            if xbmcvfs.exists(p):
                return True
        except Exception:
            pass
        try:
            return os.path.isdir(p) or os.path.exists(p)
        except Exception:
            return False

    def _listdir_safe(p: str):
        try:
            dirs, files = xbmcvfs.listdir(p)
            return files
        except Exception:
            try:
                return os.listdir(p)
            except Exception:
                return []

    # --- 0) Přímé URL (pokud modul předá rovnou stream) ---
    direct_url = params.get('url') or params.get('stream_url')
    if direct_url:
        xbmc.log(f"[PLAY] Direct URL → setResolvedUrl: {direct_url}", xbmc.LOGINFO)
        li = xbmcgui.ListItem(path=direct_url)
        li.setProperty('IsPlayable', 'true')
        # Zde nevíme TMDB ID, scrobble selže, ale je to Direct URL, ne Webshare/Series
        xbmcplugin.setResolvedUrl(_handle, True, li)
        return

    # --- 1) Series Manager výběr (select=1) ---
    if params.get('select') == '1' and params.get('series_name') and params.get('season') and params.get('episode'):
        try:
            series_name = params.get('series_name')
            season = str(params.get('season'))
            episode = str(params.get('episode'))

            # OFFLINE lookup v dfolder
            dfolder = ADDON.getSetting('dfolder') or ''
            if dfolder:
                base_real = xbmcvfs.translatePath(dfolder)
                season_folder = os.path.normpath(os.path.join(base_real, _clean_filename(series_name), f"Sezona {season}"))
                if _path_exists(season_folder):
                    # pokus najít soubor podle názvu epizody / SxxExx
                    try:
                        from resources.lib.series import series_manager
                        sm = series_manager.SeriesManager(_addon, _profile)
                        data = sm.load_series_data(series_name) or {}
                        ep = (data.get('seasons', {}).get(season, {}).get(episode, {}))
                        ep_title = ep.get('name') or ep.get('title') or ep.get('source_name') or ''
                    except Exception:
                        ep_title = ''
                        ep = {} # Zajistit, že 'ep' existuje pro případné použití
                    expected_bases = []
                    if ep_title:
                        expected_bases.append(_clean_filename(ep_title))
                    try:
                        s_i = int(season); e_i = int(episode)
                        expected_bases.append(f"S{s_i:02d}E{e_i:02d}")
                    except Exception:
                        expected_bases.append(f"S{season}E{episode}")
                    files = _listdir_safe(season_folder)
                    candidate_path = None
                    candidate_size = -1
                    for fname in files:
                        base_noext = os.path.splitext(fname)[0]
                        for b in expected_bases:
                            if base_noext == b or base_noext.lower().startswith(b.lower()):
                                full_path = os.path.join(season_folder, fname)
                                try:
                                    st = xbmcvfs.Stat(full_path)
                                    # Původní kód pro st_size je zbytečně složitý, zjednodušeno
                                    sz = st.st_size() if hasattr(st, 'st_size') and callable(st.st_size) else 0
                                except Exception:
                                    try:
                                        sz = os.path.getsize(full_path)
                                    except Exception:
                                        sz = 0
                                if sz > candidate_size:
                                    candidate_path = full_path
                                    candidate_size = sz
                                break
                    if candidate_path and _path_exists(candidate_path):
                        xbmc.log(f"[PLAY OFFLINE] Found local file: {candidate_path}", xbmc.LOGINFO)
                        play_item = xbmcgui.ListItem(path=candidate_path)
                        play_item.setProperty('IsPlayable', 'true')
                        
                        # #######################################################
                        # 🚨 ZMĚNA 1: NASTAVENÍ SCROBBLE PROPERTIES (OFFLINE)
                        # #######################################################
                        tmdb_id = ep.get('tmdb', {}).get('episode_id')  # <-- správ
                        if tmdb_id:
                            play_item.setProperty('tmdb_id', str(tmdb_id))
                            play_item.setProperty('mediatype', 'episode')
                            xbmc.log(f"[PLAY OFFLINE] SCROBBLE: Setting tmdb_id={tmdb_id}, mediatype=episode", xbmc.LOGINFO)
                        else:
                            xbmc.log("[PLAY OFFLINE] SCROBBLE: TMDB ID pro epizodu nenalezeno v series_manager datech.", xbmc.LOGWARNING)
                        # #######################################################
                        
                        # jemný MIME map (není nutné, ale pomáhá některým skinům)
                        ext = os.path.splitext(candidate_path)[1].lower()
                        mime_map = {
                            '.mkv': 'video/x-matroska',
                            '.mp4': 'video/mp4',
                            '.avi': 'video/x-msvideo',
                            '.m4v': 'video/mp4',
                            '.ts': 'video/MP2T',
                        }
                        if ext in mime_map:
                            play_item.setProperty('mimetype', mime_map[ext])
                        # --- NOVĚ: uzamknout payload pro EPIZODU + start scrobblingu (OFFLINE) ---
                        try:
                            from resources.lib.scrobble import build_episode_payload_from_db, lock_payload, scrobble_start
                            payload = build_episode_payload_from_db(series_name, int(season), int(episode))
                            if payload:
                                lock_payload(payload, last_stream_url=candidate_path, init_progress=0.0)
                                scrobble_start()
                            else:
                                xbmc.log("[PLAY OFFLINE] EP PAYLOAD: nepodařilo se sestavit payload (DB)", xbmc.LOGWARNING)
                        except Exception as e:
                            xbmc.log(f"[PLAY OFFLINE] EP PAYLOAD/LOCK/START error: {e}", xbmc.LOGERROR)

                        xbmcplugin.setResolvedUrl(_handle, True, play_item)
                        import time
                        time.sleep(0.2)
                        if not xbmc.Player().isPlaying():
                            xbmc.log("[PLAY OFFLINE] setResolvedUrl nezapálilo, zkouším Player().play(...)", xbmc.LOGWARNING)
                            xbmc.Player().play(item=candidate_path, listitem=play_item)
                        return

            # Pokud offline nic, otevři výběr streamu z JSON
            from resources.lib.series import series_manager
            sm = series_manager.SeriesManager(_addon, _profile)
            streams = series_manager.get_episode_streams(sm, series_name, season, episode)
            if not streams:
                xbmcgui.Dialog().notification(ADDON_NAME, 'Pro tuto epizodu nejsou k dispozici streamy.', xbmcgui.NOTIFICATION_WARNING, 3000)
                xbmcplugin.setResolvedUrl(_handle, False, xbmcgui.ListItem())
                return

            # runtime (min) z TMDb v JSON
            ep_runtime = None
            try:
                data = sm.load_series_data(series_name) or {}
                ep_meta = (data.get('seasons', {})
                            .get(str(season), {})
                            .get(str(episode), {})
                            .get('tmdb', {}))
                rt = ep_meta.get('runtime')
                if isinstance(rt, int) and rt > 0:
                    ep_runtime = rt
            except Exception:
                ep_runtime = None

            # 2‑řádkový dialog (useDetails), fallback na 1 řádek
            items, labels = [], []
            for st in streams:
                ln1, ln2 = series_manager.format_stream_two_lines(st, runtime=ep_runtime)
                items.append(xbmcgui.ListItem(label=ln1, label2=ln2))
                labels.append(f"{ln1} — {ln2}")
            try:
                title = f"Vyberte stream · S{int(season):02d}E{int(episode):02d}"
            except Exception:
                title = "Vyberte stream"
            try:
                idx = xbmcgui.Dialog().select(title, items, useDetails=True)
            except TypeError:
                idx = xbmcgui.Dialog().select(title, labels)
            if idx < 0:
                xbmcplugin.setResolvedUrl(_handle, False, xbmcgui.ListItem())
                return
            
            # 🚨 Důležité: Přesunout metadata do params, aby se dostaly do sekce 2
            params['ident'] = streams[idx].get('ident')
            if not params.get('name'):
                params['name'] = streams[idx].get('name') or title
                
            # #######################################################
            # 🚨 ZMĚNA 2: Přidat TMDB ID a mediatype do params pro Webshare Playback
            # #######################################################
            tmdb_ep_id = ep_meta.get('episode_id') if ep_meta else None
            if tmdb_ep_id:
                params['tmdb_id'] = str(tmdb_ep_id)  # použijeme epizodní TMDb ID
                params['mediatype'] = 'episode'
                xbmc.log(f"[PLAY SELECT] SCROBBLE PARAMS: tmdb_episode_id={tmdb_ep_id}, mediatype=episode", xbmc.LOGINFO)
            # #######################################################
                
            xbmc.log(f"[PLAY SELECT] chosen idx={idx}, ident={params['ident']}", xbmc.LOGINFO)
        except Exception as e:
            xbmc.log(f"[PLAY SELECT] error: {e}", xbmc.LOGERROR)
            xbmcplugin.setResolvedUrl(_handle, False, xbmcgui.ListItem())
            return

    # --- 2) Klasické přehrání podle Webshare ident ---
    token = revalidate()
    xbmc.log(f"[PLAY] revalidate() token: {'<NONE>' if not token else '<OK>'}", xbmc.LOGINFO)
    if not token:
        popinfo("Pro přehrávání je nutné přihlášení k Webshare (Nastavení → Účet).", icon=xbmcgui.NOTIFICATION_WARNING)
        xbmcplugin.setResolvedUrl(_handle, False, xbmcgui.ListItem())
        return
    ident = params.get('ident')
    name = params.get('name', '')
    if not ident:
        popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)
        xbmcplugin.setResolvedUrl(_handle, False, xbmcgui.ListItem())
        return

    # getlink → Kodi standard "pipe headers": URL|k=v&k2=v2 (standard)
    link = None
    try:
        xbmc.log(f"[PLAY] requesting link for ident={ident}", xbmc.LOGDEBUG)
        link = getlink(ident, token) # token param u wrapperu nevadí; signatura zůstává
        xbmc.log(f"[PLAY] getlink() returned: {link}", xbmc.LOGDEBUG)
    except Exception as e:
        xbmc.log(f"[PLAY] getlink() error: {e}", xbmc.LOGERROR)
    if not link:
        popinfo(_addon.getLocalizedString(30107), icon=xbmcgui.NOTIFICATION_WARNING)
        xbmcplugin.setResolvedUrl(_handle, False, xbmcgui.ListItem())
        return

    try:
        # Základní headers
        headers = {
            'Cookie': 'wst=' + (token or ''),
            'User-Agent': UA,
            'Referer': BASE,
        }
        
        # Standardní Kodi URL s pipe headers
        link_with_headers = f"{link}|{urlencode(headers)}"
        
        # Přidáme tmdb_id a mediatype ZA pipe část (jako dodatečné query parametry)
        if params.get('tmdb_id') and params.get('mediatype'):
            extra_params = urlencode({
                'tmdb_id': params['tmdb_id'],
                'mediatype': params['mediatype']
            })
            final_url = f"{link_with_headers}&{extra_params}"
            xbmc.log(f"[PLAY] Final URL s scrobble parametry: {final_url}", xbmc.LOGINFO)
        else:
            final_url = link_with_headers
            xbmc.log(f"[PLAY] Final URL bez scrobble parametrů: {final_url}", xbmc.LOGINFO)
        
        link_with_headers = final_url
        
        li = xbmcgui.ListItem(label=name, path=link_with_headers)
        li.setProperty('IsPlayable', 'true')
        li.setProperty('mimetype', 'application/octet-stream')
        
        # #######################################################
        # 🚨 ZMĚNA 3: NASTAVENÍ SCROBBLE PROPERTIES (WEBSHARE STREAM)
        # #######################################################
        tmdb_id = params.get('tmdb_id')
        mediatype = params.get('mediatype')
        
        if tmdb_id and mediatype:
            li.setProperty('tmdb_id', str(tmdb_id))
            li.setProperty('mediatype', mediatype)
            xbmc.log(f"[PLAY STREAM] SCROBBLE: Setting tmdb_id={tmdb_id}, mediatype={mediatype}", xbmc.LOGINFO)
        else:
            xbmc.log("[PLAY STREAM] SCROBBLE: Chybí tmdb_id nebo mediatype v parametrech pro Webshare stream.", xbmc.LOGWARNING)
        # #######################################################

        # --- NOVĚ: Uzamknout payload pro EPIZODU + start scrobblingu (ONLINE/WEBSHARE) ---
        try:
            # Pro epizody očekáváme v params tyto klíče (přichází z SeriesManager UI):
            series_name_p = params.get('series_name')
            season_p = params.get('season')
            episode_p = params.get('episode')

            if series_name_p and season_p and episode_p and (params.get('mediatype') == 'episode'):
                from resources.lib.scrobble import build_episode_payload_from_db, lock_payload, scrobble_start
                payload = build_episode_payload_from_db(series_name_p, int(season_p), int(episode_p))
                if payload:
                    # Uzamknout payload + uložit aktuální stream URL pro historii (play z historie)
                    lock_payload(payload, last_stream_url=link_with_headers, init_progress=0.0)
                    scrobble_start()
                    xbmc.log("[PLAY STREAM] EP PAYLOAD: uzamknut + start", xbmc.LOGINFO)
                else:
                    xbmc.log("[PLAY STREAM] EP PAYLOAD: nepodařilo se sestavit payload (DB)", xbmc.LOGWARNING)
            else:
                # Poznámka: pokud přehráváme epizodu mimo SeriesManager (bez params), payload nevznikne
                xbmc.log("[PLAY STREAM] EP PAYLOAD: chybí series_name/season/episode v params nebo mediatype!=episode", xbmc.LOGDEBUG)
        except Exception as e:
            xbmc.log(f"[PLAY STREAM] EP PAYLOAD/LOCK/START error: {e}", xbmc.LOGERROR)
        
        xbmcplugin.setResolvedUrl(_handle, True, li)
        # #######################################################
        # 🚨 NOVÉ: Přímé spuštění scrobble pro Webshare streamy (spolehlivé)
        # #######################################################
        if tmdb_id and mediatype == 'movie':
            try:
                from resources.lib.scrobble import build_payload_from_id, scrobble_start
                from datetime import datetime
                
                payload = build_payload_from_id(tmdb_id, mediatype)
                if payload:
                    addon = xbmcaddon.Addon('plugin.video.mmirousek_v2')
                    addon.setSetting('trakt_last_payload', json.dumps(payload))
                    addon.setSetting('trakt_payload_locked', 'true')
                    addon.setSetting('last_stream_url', link_with_headers)
                    xbmc.log(f'[PLAY] Uložena last_stream_url pro rozkoukáno: {link_with_headers}', xbmc.LOGDEBUG)
                    
                    addon.setSetting('trakt_last_progress', '100.0')  # zajistíme, že stop to pozná
                    
                    clean_title = (payload.get('movie', {}).get('title') or 'Neznámý film')
                    
                    item_for_local_db = {
                        "name": clean_title,
                        "media_type": "movie",
                        "tmdb_id": str(tmdb_id),
                        "progress": 100.0,
                        "watched_at": datetime.utcnow().strftime('%Y-%m-%dT%H:%M:%S'),
                        "stream_url": link_with_headers,   # ← důležité pro přehrání z historie
                        "trakt_payload": payload,
                        "movie": payload.get('movie')
                    }
                    
                    from resources.lib import local_history
                    local_history.store_item(item_for_local_db)
                    xbmc.log(f'[PLAY] Dokončený film uložen do historie: {clean_title}', xbmc.LOGINFO)
                    
                    scrobble_start()
            except Exception as e:
                xbmc.log(f'[PLAY] Chyba při ukládání dokončeného filmu: {e}', xbmc.LOGERROR)        
        
        # #######################################################


        import time
        time.sleep(0.2)
        if not xbmc.Player().isPlaying():
            xbmc.log("[PLAY] setResolvedUrl nezapálilo, zkouším Player().play(...)", xbmc.LOGWARNING)
            xbmc.Player().play(item=link_with_headers, listitem=li)
    except Exception as e:
        xbmc.log(f"[PLAY] setResolvedUrl/Player error: {e}", xbmc.LOGERROR)
        xbmcplugin.setResolvedUrl(_handle, False, xbmcgui.ListItem())

def db(params):
    token = revalidate()
    updateListing=False
    dbdir = os.path.join(_profile,'db')
    if not os.path.exists(dbdir):
        link = getlink(BACKUP_DB,token)
        dbfile = os.path.join(_profile,'db.zip')
        with io.open(dbfile, 'wb') as bf:
            response = _session.get(link, stream=True)
            bf.write(response.content)
            bf.flush()
            bf.close()
        with zipfile.ZipFile(dbfile, 'r') as zf:
            zf.extractall(_profile)
        os.unlink(dbfile)
    if 'toqueue' in params:
        toqueue(params['toqueue'],token)
        updateListing=True
    if 'file' in params and 'key' in params:
        data = loaddb(dbdir,params['file'])
        item = next((x for x in data if x['id'] == params['key']), None)
        if item is not None:
            for stream in item['streams']:
                commands = []
                commands.append(( _addon.getLocalizedString(30214), 'Container.Update(' + get_url(action='db',file=params['file'],key=params['key'],toqueue=stream['ident']) + ')' ))
                listitem = tolistitem({'ident':stream['ident'],'name':stream['quality'] + ' - ' + stream['lang'] + ' ' + stream['ainfo'],'sizelized':stream['size']},commands)
                xbmcplugin.addDirectoryItem(_handle, get_url(action='play',ident=stream['ident'],name=item['title']), listitem, False)
    elif 'file' in params:
        data = loaddb(dbdir,params['file'])
        for item in data:
            listitem = xbmcgui.ListItem(label=item['title'])
            if 'plot' in item:
                listitem.setInfo('video', {'title': item['title'],'plot': item['plot']})
            xbmcplugin.addDirectoryItem(_handle, get_url(action='db',file=params['file'],key=item['id']), listitem, True)
    else:
        if os.path.exists(dbdir):
            dbfiles = [f for f in os.listdir(dbdir) if os.path.isfile(os.path.join(dbdir, f))]
            for file in dbfiles:
                if not file.startswith('.') and file.endswith('.json'):
                    listitem = xbmcgui.ListItem(label=file[:-5])
                    listitem.setArt({'icon': 'DefaultFolder.png'})
                    xbmcplugin.addDirectoryItem(_handle, get_url(action='db',file=file), listitem, True)
    xbmcplugin.endOfDirectory(_handle, updateListing=updateListing)

def delete_history_item(tmdb_id, media_type):
    """Odstraní položku z lokální historie a obnoví seznam."""
    if local_history.remove_item(tmdb_id, media_type):
        xbmcgui.Dialog().notification(ADDON_NAME, "Položka smazána z historie.", xbmcgui.NOTIFICATION_INFO)
    # Refresh listu po smazání, aby zmizela smazaná položka
    xbmc.executebuiltin('Container.Refresh()')

def play_history_item(url, tmdb_id, media_type):
    """Zahájí přehrávání z historie a připraví data pro scrobbling (nový systém)."""
    if not url:
        xbmcgui.Dialog().notification(ADDON_NAME, "Nelze přehrát: Chybí stream URL.", xbmcgui.NOTIFICATION_ERROR)
        return

    # 1. Načteme celou položku z historie
    full_item = local_history.get_single_item(tmdb_id, media_type)
    if not full_item:
        xbmc.log(f"[play_history_item] Položka nenalezena: tmdb_id={tmdb_id}, media_type={media_type}", xbmc.LOGWARNING)
        # Pokračujeme i bez payloadu – přehraje se, ale bez scrobblingu
    else:
        try:
            addon = xbmcaddon.Addon(ADDON_ID)
            
            # Načteme Trakt payload (má ho uložený v položce)
            payload = full_item.get('trakt_payload', {})
            if payload:
                addon.setSetting('trakt_last_payload', json.dumps(payload))
                addon.setSetting('trakt_payload_locked', 'true')
                
                # Volitelně – uložíme i aktuální progress (aby scrobble_stop() věděl, kde začít)
                progress = full_item.get('progress', 0.0)
                addon.setSetting('trakt_last_progress', str(progress))
                
                xbmc.log(f"[play_history_item] Scrobbling připraven: {full_item.get('name', 'Neznámý')} ({progress}%)", xbmc.LOGINFO)
            else:
                xbmc.log(f"[play_history_item] Položka nemá trakt_payload – scrobbling nebude fungovat.", xbmc.LOGWARNING)
        except Exception as e:
            xbmc.log(f"[play_history_item] Chyba při přípravě scrobblingu: {e}", xbmc.LOGERROR)

    # 2. Spustíme přehrávání
    play_item = xbmcgui.ListItem(path=url)
    play_item.setProperty('IsPlayable', 'true')
    xbmcplugin.setResolvedUrl(_handle, True, play_item)

def csfd_play_or_open(params):
    """
    Rozhodnutí po kliku na položku ČSFD Toplistu:
    - TV => Series Manager (series_search & what=title)
    - Film => zkus playlist index (tmdb_id -> play; title+year -> play),
      jinak nabídni fallback: hledat na Webshare?
    """
    media_type = (params.get('media_type') or '').lower()
    title = params.get('title') or ''
    year = None
    try:
        if params.get('year'): year = int(params.get('year'))
    except Exception:
        year = None
    tmdb_id = int(params.get('tmdb_id') or 0)

    # 1) Seriál -> Series Manager
    if media_type == 'tv':
        # poslat rovnou do series_search (bez dotazu na klávesnici)
        xbmc.executebuiltin(f"Container.Update({get_url(action='series_search', what=title)})")
        return

    # 2) Film -> playlist index
    # cesta k M3U z nastavení
    m3u_path = ADDON.getSetting('playlist_path') or ''
    if not m3u_path:
        xbmcgui.Dialog().notification(ADDON_NAME, "Chybí cesta k M3U v nastavení.", xbmcgui.NOTIFICATION_WARNING)
        # fallback přímo na Webshare
        xbmc.executebuiltin(f"Container.Update({get_url(action='search', what=title)})")
        return

    # načti nebo přestav index (tichý rebuild pouze když je zastaralý)
    from resources.lib import playlist_index
    idx = playlist_index.load_index_json()
    if not idx or playlist_index.needs_rebuild(m3u_path, idx):
        # rychlý rebuild bez progress baru (aby UX bylo plynulé)
        idx = playlist_index.rebuild_if_needed(m3u_path, is_tv=False, force=True, show_progress=False)
    if not idx:
        # nemáme index -> nabídni fallback na Webshare
        if xbmcgui.Dialog().yesno(ADDON_NAME, "Index playlistu nenalezen. Hledat na Webshare?"):
            xbmc.executebuiltin(f"Container.Update({get_url(action='search', what=title)})")
        return

    # najdi nejlepší shodu
    best = playlist_index.find_best_match(idx, tmdb_id=tmdb_id, title=title, year=year)
    if best and (best.get('m3u_url') or ''):
        from resources.lib import playlist_loader
        # KLÍČOVÉ: předat aktuální handle (_handle) – viz výše
        playlist_loader.play_m3u_stream(best['m3u_url'], handle=_handle)
        return

    # fallback: nabídnout vyhledání na Webshare
    if xbmcgui.Dialog().yesno(ADDON_NAME, f"„{title}“ v playlistu nenalezen.\nHledat na Webshare?"):
        xbmc.executebuiltin(f"Container.Update({get_url(action='search', what=title)})")
    else:
        xbmcplugin.endOfDirectory(_handle, succeeded=False)

def trakt_search_dialog(params):
    """
    Zobrazí vyhledávací dialog Kodi a spustí vyhledávání na Trakt.tv.
    """
    # 1. Zobrazení dialogu pro zadání dotazu
    query = xbmcgui.Dialog().input(
        'Hledej na Trakt.tv (Název filmu/seriálu)', 
        type=xbmcgui.INPUT_TYPE_TEXT
    )
    
    if not query:
        # Zrušeno uživatelem
        return

    url = get_url(action='trakt_search_results', query=query)
    xbmc.executebuiltin(f'Container.Update({url})')

from resources.lib.utils.ui_utils import make_static_item
def movies_menu(params):
    """Podmenu pro sekci Filmy: Naposledy sledované + Stažené filmy + Historie."""
    import xbmcplugin

    xbmcplugin.setPluginCategory(_handle, "Filmy")

    # 1) Naposledy sledované filmy
    li_history_movies = make_static_item(
        label="Naposledy sledované filmy",
        plot=(
            "Zobrazí seznam naposledy sledovaných filmů.\n"
            "• Umožní rychlé opakování přehrávání.\n"
            "• Data jsou z lokální historie doplňku."
        ),
        addon=_addon,
        icon_name='recent_movies.png',  # vlastní ikona v resources/media/icons
        default_icon='DefaultRecentlyAddedMovies.png'
    )
    xbmcplugin.addDirectoryItem(
        _handle,
        get_url(action='watch_history_list', type='movie'),
        li_history_movies,
        isFolder=True
    )

    # 2) Stažené filmy
    li_downloaded = make_static_item(
        label="Stažené filmy",
        plot=(
            "Zobrazí seznam filmů stažených do offline složky.\n"
            "• Umožní přehrávání bez internetu.\n"
            "• Možnost mazání souborů."
        ),
        addon=_addon,
        icon_name='downloaded.png',
        default_icon='DefaultHardDisk.png'
    )
    xbmcplugin.addDirectoryItem(
        _handle,
        get_url(action='movies_downloaded'),
        li_downloaded,
        isFolder=True
    )

# 4) Sledovat později (Webshare Watchlist)
    li_watchlist = make_static_item(
        label="Sledovat později",
        plot=(
            "Zobrazí seznam filmů, které sis označil(a) pro pozdější zhlédnutí.\n"
            "• Položky jsou řazeny dle data přidání.\n"
            "• Snadné odebrání ze seznamu."
        ),
        addon=_addon,
        icon_name='watchlist.png',  # 🚨 POUŽIJ ROZUMNOU IKONU (musíš ji mít v resources/media/icons)
        default_icon='DefaultFavourites.png'
    )
    xbmcplugin.addDirectoryItem(
        _handle,
        get_url(action='watchlist_list', type='movie'), # 🚨 Zde definujeme novou akci!
        li_watchlist,
        isFolder=True
    )

    # 3) Historie (Webshare)
    li_ws_history = make_static_item(
        label="Historie",
        plot=(
            "Historie přehrávání a stahování z Webshare.\n"
            "• Lze znovu přehrát položky nebo je vyčistit.\n"
            "• Stejné jako https://webshare.cz/#/history"
        ),
        addon=_addon,
        icon_name='watched.png',
        default_icon='DefaultRecentlyAddedEpisodes.png'
    )
    xbmcplugin.addDirectoryItem(
        _handle,
        get_url(action='history'),
        li_ws_history,
        isFolder=True
    )
    xbmcplugin.endOfDirectory(_handle)


# --- Experimentální podmenu: UI nad skrytými settings + nástroje ---
def _yescolor(flag: bool) -> str:
    return "[COLOR lime]Zapnuto[/COLOR]" if flag else "[COLOR red]Vypnuto[/COLOR]"

def _short(path: str, fallback: str = "Nenastaveno") -> str:
    if not path:
        return fallback
    p = str(path).replace("\\", "/").rstrip("/")
    parts = p.split("/")
    return "/".join(parts[-2:]) if len(parts) >= 2 else p

def show_experimental_menu():
    import xbmcplugin
    from resources.lib.utils.ui_utils import pick_icon, add_menu_item

    handle = _handle
    xbmcplugin.setPluginCategory(handle, "Experimentální funkce")

    # Načti aktuální hodnoty (bezpečně kvůli starším verzím Kodi)
    def _get_bool(k, default=False):
        try:
            return ADDON.getSettingBool(k)
        except Exception:
            return (ADDON.getSetting(k) or "").lower() == "true" if ADDON.getSetting(k) is not None else default

    enable_lib = _get_bool('enable_library_export', False)
    enable_m3u = _get_bool('enable_m3u_library', False)
    force_m3u  = _get_bool('m3u_export_force', False)
    playlist   = ADDON.getSetting('playlist_path') or ''

    # 1) Přepínače
    add_menu_item(
        handle=handle, build_url_fn=get_url,
        label=f"Knihovna Kodi (.strm): {_yescolor(enable_lib)}",
        plot="Zapne/vypne export seriálů do Kodi knihovny (.strm).",
        action='exp_toggle_bool',
        art_icon=pick_icon(_addon, 'toggle.png', 'DefaultAddonService.png'),
        is_folder=False, key='enable_library_export'
    )

    add_menu_item(
        handle=handle, build_url_fn=get_url,
        label=f"M3U → Knihovna (.strm): {_yescolor(enable_m3u)}",
        plot="Zapne/vypne export filmů z playlistu M3U do Kodi knihovny (.strm).",
        action='exp_toggle_bool',
        art_icon=pick_icon(_addon, 'toggle.png', 'DefaultAddonService.png'),
        is_folder=False, key='enable_m3u_library'
    )

    add_menu_item(
        handle=handle, build_url_fn=get_url,
        label=f"Force M3U export: {_yescolor(force_m3u)}",
        plot="Při exportu z M3U ignoruje změny a přegeneruje vše.",
        action='exp_toggle_bool',
        art_icon=pick_icon(_addon, 'toggle.png', 'DefaultAddonService.png'),
        is_folder=False, key='m3u_export_force'
    )

    # 2) Cesta k playlistu
    add_menu_item(
        handle=handle, build_url_fn=get_url,
        label=f"Cesta k playlistu M3U: [COLOR gold]{_short(playlist)}[/COLOR]",
        plot="Vyber soubor playlistu (.m3u / .m3u8).",
        action='exp_browse_file',
        art_icon=pick_icon(_addon, 'folder.png', 'DefaultFolder.png'),
        is_folder=False, key='playlist_path'
    )

    # 3) TMDb audit & doplnění metadat (CZ/EN)
    add_menu_item(
        handle=handle, build_url_fn=get_url,
        label='TMDb audit & doplnění metadat (CZ/EN)',
        plot='Projede celou DB: opraví title_cs/title_en (latinka), doplní overview_cs/en, rok, poster, backdrop.',
        action='tmdb_audit_fill',
        art_icon=pick_icon(_addon, 'tmdb.png', 'DefaultPicture.png', 'tmdb'),
        is_folder=False
    )

    # 4) (Volitelně) Zobrazit log doplňku
    add_menu_item(
        handle=handle, build_url_fn=get_url,
        label='Log doplňku',
        plot='Zobrazí poslední řádky aplikačního logu (app.log).',
        action='show_app_log',
        art_icon=pick_icon(_addon, 'log.png', 'DefaultAddonService.png'),
        is_folder=False
    )

    xbmcplugin.endOfDirectory(handle)

# --- Akce: přepnout boolean setting ---
def exp_toggle_bool(key: str):
    import xbmcgui
    if not key:
        xbmcgui.Dialog().notification(ADDON.getAddonInfo('name'), "Chybí klíč nastavení.", xbmcgui.NOTIFICATION_ERROR, 2500)
        return
    try:
        try:
            cur = ADDON.getSettingBool(key)
            ADDON.setSettingBool(key, not cur)
            newv = not cur
        except Exception:
            cur = (ADDON.getSetting(key) or "").lower() == "true"
            ADDON.setSetting(key, "true" if (not cur) else "false")
            newv = (not cur)
        xbmcgui.Dialog().notification("Nastavení", f"{key}: {'Zapnuto' if newv else 'Vypnuto'}", xbmcgui.NOTIFICATION_INFO, 2000)
    except Exception as e:
        xbmcgui.Dialog().notification("Nastavení", f"Chyba: {e}", xbmcgui.NOTIFICATION_ERROR, 3000)
    # refresh obrazovky, ať se hned projeví label
    import xbmc
    xbmc.executebuiltin('Container.Refresh')

# --- Akce: vybrat soubor a uložit do settings ---
def exp_browse_file(key: str):
    import xbmcgui, xbmcvfs
    if not key:
        xbmcgui.Dialog().notification(ADDON.getAddonInfo('name'), "Chybí klíč nastavení.", xbmcgui.NOTIFICATION_ERROR, 2500)
        return
    try:
        # Dialog browse: 1 = FILES (Kodi API), maska pro m3u/m3u8
        path = xbmcgui.Dialog().browse(1, "Vyber playlist M3U", "files", mask="*.m3u|*.m3u8")
        if path:
            # Přeložit případné special:// a uložit raw cestu
            try:
                # pokud je special://, necháme ji jako special – Kodi s ní umí pracovat
                resolved = xbmcvfs.translatePath(path) if path.startswith("special://") else path
            except Exception:
                resolved = path
            ADDON.setSetting(key, resolved)
            xbmcgui.Dialog().notification("Nastavení", "Cesta uložena.", xbmcgui.NOTIFICATION_INFO, 2000)
        else:
            xbmcgui.Dialog().notification("Nastavení", "Výběr zrušen.", xbmcgui.NOTIFICATION_INFO, 1500)
    except Exception as e:
        xbmcgui.Dialog().notification("Nastavení", f"Chyba výběru: {e}", xbmcgui.NOTIFICATION_ERROR, 3000)
    import xbmc
    xbmc.executebuiltin('Container.Refresh')
# ----------------------------------------------------------------------------------------------------
# --- NOVÝ Hlavní router s centrálním dispatchem + aliasy + sjednocené helpery ---
def router(paramstring):
    """
    Hlavní směrovač akcí doplňku (YaWSP/MM).
    - Vyhodnocuje aliasy -> kanonické názvy akcí.
    - Každá akce je mapovaná pouze jednou.
    - Jednotný logovací prefix: mm.hlavni_router
    """
    LOG_PREFIX = "mm.hlavni_router"

    # --- parsování parametrů
    params = dict(parse_qsl(paramstring)) if paramstring else {}
    action = (params.get('action') or '').strip()

    xbmc.log(f"[{LOG_PREFIX}] in: action={action} params={params}", xbmc.LOGDEBUG)

    # --- HELPERY (lokální; používají je některé akce níže)
    def _safe_int(v, default=0):
        try:
            return int(v)
        except Exception:
            return default

    def _mark_skip_full_fetch():
        """Jednorázově přeskočí full-fetch při nejbližším ensure_cache()."""
        try:
            xbmcgui.Window(10000).setProperty('mm_skip_full_fetch', '1')
            xbmc.log(f"[{LOG_PREFIX}] set flag mm_skip_full_fetch=1", xbmc.LOGINFO)
        except Exception as e:
            xbmc.log(f"[{LOG_PREFIX}] skip_full_fetch flag error: {e}", xbmc.LOGWARNING)

    def _set_full_fetch_cooldown(seconds=300):
        """Cooldown (v sekundách), během něhož ensure_cache() ignoruje full-fetch."""
        try:
            import time
            until = time.time() + float(seconds)
            xbmcgui.Window(10000).setProperty('mm_full_fetch_cooldown_until', str(until))
            xbmc.log(f"[{LOG_PREFIX}] full-fetch cooldown set: {int(seconds)}s", xbmc.LOGINFO)
        except Exception as e:
            xbmc.log(f"[{LOG_PREFIX}] cooldown set error: {e}", xbmc.LOGWARNING)

    def _delete_history_prompt_and_refresh(p):
        """Prompt na smazání Trakt historie (show/season) + rychlý návrat do 'Pokrok'."""
        try:
            from resources.lib.trakt.trakt_module import trakt_delete_history
            kind = (p.get('kind') or '').lower()  # 'show' | 'season'
            trakt_id = _safe_int(p.get('trakt_id'), 0)
            season_num = p.get('season')

            if kind == 'season' and (season_num is None or not str(season_num).isdigit()):
                kb = xbmc.Keyboard('', 'Číslo sezóny pro smazání')
                kb.doModal()
                if not kb.isConfirmed():
                    return
                season_txt = (kb.getText() or '').strip()
                if not season_txt.isdigit():
                    xbmcgui.Dialog().notification('Trakt', 'Zadejte číslo sezóny (jen čísla).', xbmcgui.NOTIFICATION_WARNING)
                    return
                season_num = season_txt

            trakt_delete_history(kind=kind, trakt_id=trakt_id, season=int(season_num) if season_num else None)
            _mark_skip_full_fetch()
            _set_full_fetch_cooldown(seconds=300)
            _update_progress_view()
        except Exception as e:
            xbmc.log(f"[{LOG_PREFIX}] trakt_delete_history error: {e}", xbmc.LOGERROR)
            xbmcgui.Dialog().notification('Trakt', 'Chyba mazání historie.', xbmcgui.NOTIFICATION_ERROR, 3000)

    def _download_whole_show(p):
        """Stáhne celý seriál (iteruje přes sezóny)."""
        try:
            sm = series_manager.SeriesManager(_addon, _profile)
            data = sm.load_series_data(p.get('series_name', '')) or {}
            from resources.lib.down.offline_manager import save_season
            for s in sorted((data.get('seasons') or {}).keys(), key=int):
                save_season(p.get('series_name', ''), s, sm)
            xbmcgui.Dialog().notification(ADDON_NAME, "Stahování celého seriálu zahájeno.", xbmcgui.NOTIFICATION_INFO, 2500)
        except Exception as e:
            xbmc.log(f"[{LOG_PREFIX}] download_whole_show error: {e}", xbmc.LOGERROR)
            xbmcgui.Dialog().notification(ADDON_NAME, "Chyba stahování.", xbmcgui.NOTIFICATION_ERROR, 3000)

    def _show_watch_history_list_entry(p):
        """Zobrazí rychlý listing z local_history (filmy)."""
        try:
            from resources.lib import local_history
            media_type = p.get('type') or 'movie'
            items = local_history.get_list_items(media_type=media_type)
            if not items:
                xbmcgui.Dialog().notification(_addon.getAddonInfo('name'), "Historie je prázdná.", xbmcgui.NOTIFICATION_INFO, 2500)
                xbmcplugin.endOfDirectory(_handle, succeeded=True)
                return
            xbmcplugin.addDirectoryItems(_handle, items)
            xbmcplugin.endOfDirectory(_handle)
        except Exception as e:
            xbmc.log(f"[{LOG_PREFIX}] watch_history_list error: {e}", xbmc.LOGERROR)
            xbmcgui.Dialog().notification(_addon.getAddonInfo('name'), "Chyba při načítání historie.", xbmcgui.NOTIFICATION_ERROR, 3000)
            xbmcplugin.endOfDirectory(_handle, succeeded=False)

    def _play_m3u(m3u_url):
        """Bezpečné přehrání M3U streamu (s podporou novější signatury)."""
        try:
            from resources.lib import playlist_loader
            try:
                playlist_loader.play_m3u_stream(m3u_url, handle=_handle)
            except TypeError:
                playlist_loader.play_m3u_stream(m3u_url)
        except Exception as e:
            xbmc.log(f"[{LOG_PREFIX}] play_m3u_stream error: {e}", xbmc.LOGERROR)
            xbmcgui.Dialog().notification(_addon.getAddonInfo('name'), "Chyba M3U streamu.", xbmcgui.NOTIFICATION_ERROR, 3000)

  
    # --- aliasy: převedeme na kanonické názvy
    ALIASES = {
        # hubs
        'trak_movies_hub': 'trakt_movies_hub',
        'trakt_movie_hub': 'trakt_movies_hub',
        'trak_shows_hub': 'trakt_shows_hub',
        'trak_show_hub': 'trakt_shows_hub',
        'trak_lists_hub': 'trakt_lists_hub',
        # m3u play
        'csfd_play_m3u_stream': 'play_m3u_stream',
        # drobné překlepy v názvech
        'trak_show_next_last':  'trakt_show_next_last',
        'trakt_next_last':      'trakt_show_next_last',
        'series_trakt_mark_season_prompt':  'trakt_prompt_mark_season',
        'series_trakt_mark_episode_prompt': 'trakt_prompt_mark_episode',
        'series_trakt_mark_show_prompt': 'trakt_prompt_mark_season',  # není 1:1, pro show prompt u nás není separátní akce
    }
    action = ALIASES.get(action, action)

    # --- pokud není akce => vykresli hlavní menu (původní logika, jen sjednocený log prefix)
    if not action:
        xbmcplugin.setPluginCategory(_handle, _addon.getAddonInfo('name'))

        # jemný VIP popup na start
        _vip_start_popup_if_needed(threshold_days=11)

        # --- Spustit Trakt scrobble službu jen při vstupu do doplňku (session guard) ---
        try:
            win = xbmcgui.Window(10000)
            if win.getProperty('mm_scrobble_service_started') != '1':
                addon_path = xbmcvfs.translatePath(_addon.getAddonInfo('path'))
                script_path = os.path.join(addon_path, 'service.py')
                xbmc.executebuiltin(f'RunScript("{script_path}", wait)')
                win.setProperty('mm_scrobble_service_started', '1')
                xbmc.log('[Scrobble] service.py spuštěn při vstupu do doplňku', xbmc.LOGINFO)
        except Exception as e:
            xbmc.log(f'[Scrobble] start služby selhal: {e}', xbmc.LOGWARNING)

        # Společné utilitky
        from resources.lib.utils.ui_utils import pick_icon, add_menu_item

        # --- Neklikací info o úložišti / velikosti dat doplňku ---
        import shutil

        free_gb = total_gb = "?"
        addon_mb = "?"

        try:
            free_gb, total_gb = get_storage_info()
        except Exception:
            pass

        try:
            addon_mb = get_addon_data_size_mb()
        except Exception:
            pass

        target_info = ""
        dfolder = ADDON.getSetting('dfolder') or ''

        if dfolder:
            try:
                target_real = xbmcvfs.translatePath(dfolder)
                if target_real:
                    if not target_real.endswith(('/', '\\')):
                        target_real += '/'

                    # Zjistíme, jestli je to lokální cesta (začíná písmenem jednotky nebo /)
                    is_local = (
                        target_real[0].isalpha() and target_real[1:3] == ':\\' or  # C:\, D:\
                        target_real.startswith('/') or                               # Linux/Android
                        target_real.startswith('/storage/') or
                        target_real.startswith('/sdcard/')
                    )

                    if is_local:
                        try:
                            usage = shutil.disk_usage(target_real)
                            free_t = round(usage.free / (1024**3), 2)
                            total_t = round(usage.total / (1024**3), 2)
                            target_info = f" • [COLOR darkblue]Stahování: {free_t}/{total_t} GB volno[/COLOR]"
                        except Exception:
                            target_info = " • [COLOR orange]Stahování: nelze zjistit místo[/COLOR]"
                    else:
                        # Síťová cesta
                        short = '/'.join(target_real.rstrip('/').split('/')[-2:])
                        target_info = f" • [COLOR orange]Stahování: {short} [síťový disk][/COLOR]"

            except Exception as e:
                xbmc.log(f"[Router] Chyba při zpracování dfolder: {e}", xbmc.LOGWARNING)
                target_info = " • [COLOR red]Stahování: chyba[/COLOR]"
        else:
            target_info = " • [COLOR gray]Stahování: nenastaveno[/COLOR]"

        label_info = f"[COLOR green]Úložiště: {free_gb}/{total_gb} GB • Data: {addon_mb} MB[/COLOR]{target_info}"
        li_info = xbmcgui.ListItem(label=label_info)
        li_info.setArt({'icon': 'DefaultHardDisk.png'})
        xbmcplugin.addDirectoryItem(_handle, get_url(action='refresh_main'), li_info, isFolder=False)
        
        # Hlavní položky
        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label=_addon.getLocalizedString(30201),  # "Hledat"
            plot="Vyhledávání souborů na Webshare. \nUkládá dotazy do historie pro rychlé opakování.",
            action='search',
            art_icon=pick_icon(_addon, 'search.png', 'DefaultAddonsSearch.png'),
            is_folder=True
        )
        # Lazy import fronty pro bezpečnost
        # --- Fronta stahování (filmy + epizody) ---
        from resources.lib.down.download_queue import get_queue_summary, get_queue_stats

        summary = get_queue_summary()
        downloading_count = summary.get("downloading", 0)
        pending_count = summary.get("pending", 0)
        total_count = summary.get("total", 0)

        # Zkus načíst detailní statistiky (GB + ETA)
        try:
            pending_c, downloading_c, total_gb, remaining_gb, eta_min = get_queue_stats(avg_speed_mbps=10.0)
        except Exception:
            total_gb, remaining_gb, eta_min = 0, 0, None

        # Základní label
        label = "Fronta stahování"

        # Přidáme prefix, pokud něco je ve frontě
        if downloading_count > 0 or pending_count > 0:
            status_tag = (
                f"[COLOR lime]↓ stahuje: {downloading_count}[/COLOR] • "
                f"[COLOR gray]ve frontě: {pending_count}[/COLOR]"
            )
            if remaining_gb > 0:
                status_tag += f" • [COLOR yellow]zbývá: {remaining_gb} GB[/COLOR]"
            if eta_min:
                status_tag += f" • [COLOR orange]ETA: {eta_min} min[/COLOR]"
            label = f"{label} {status_tag}"

        # Plot pro detailní info
        plot = (
            f"Celkem položek: {total_count} • "
            f"Stahuje: {downloading_count} • Čeká: {pending_count}"
        )
        if total_gb > 0:
            plot += f" • Celkem: {total_gb} GB"
        if remaining_gb > 0:
            plot += f" • Zbývá: {remaining_gb} GB"
        if eta_min:
            plot += f" • Odhad dokončení: {eta_min} min"

        # Přidání položky do hlavního menu
        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label=label,
            plot=plot,
            action='queue_menu',
            art_icon=pick_icon(_addon, 'download_queue.png', 'DefaultHardDisk.png'),
            is_folder=True
        )
        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label='Seriály',
            plot = (
                "  Správce seriálů:\n"
                "• Vyhledá a setřídí epizody do sezón\n"
                "• Nabízí aktualizaci a detailní navigaci\n"
                "• Možnost stahování do zvolené složky\n"
                "• Přehrávání pak probíhá offline\n"
            ),
            action='series',
            art_icon=pick_icon(_addon, 'series.png', 'DefaultTvShowTitle.png'),
            is_folder=True
        )
        
        add_menu_item(
            handle=_handle,
            build_url_fn=get_url,
            label='Trakt kalendář (30 dní)',
            plot='Zobrazí přehled nadcházejících epizod z Trakt.tv na 30 dní dopředu.',
            action='trakt_calendar',
            art_icon=pick_icon(_addon, 'trakt.png', 'DefaultPicture.png'),
            is_folder=True  # otevře listing (tvé list_calendar_shows)
        )

        # Experimentální funkce – zobraz jen, když je povoleno v Settings
        try:
            if ADDON.getSettingBool('experimental'):
                from resources.lib.utils.ui_utils import pick_icon, add_menu_item
                add_menu_item(
                    handle=_handle,
                    build_url_fn=get_url,
                    label='Experimentální funkce',
                    plot='Podpůrné volby a nástroje ve vývoji: knihovna, M3U, TMDb audit.',
                    action='exp_menu',
                    art_icon=pick_icon(_addon, 'settings_experimental.png', 'DefaultAddonService.png'),
                    is_folder=True
                )
        except Exception:
            if (ADDON.getSetting('experimental') or '').lower() == 'true':
                from resources.lib.utils.ui_utils import pick_icon, add_menu_item
                add_menu_item(
                    handle=_handle,
                    build_url_fn=get_url,
                    label='Experimentální funkce',
                    plot='Podpůrné volby a nástroje ve vývoji: knihovna, M3U, TMDb audit.',
                    action='exp_menu',
                    art_icon=pick_icon(_addon, 'settings_experimental.png', 'DefaultAddonService.png'),
                            is_folder=True
                )
        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label='Filmy',
            plot="Sekce Filmy: přístup k historii sledování a staženým filmům.",
            action='movies_menu',
            art_icon=pick_icon(_addon, 'filmy.png', 'DefaultMovieTitle.png'),
            is_folder=True
        )

        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label='TMDb databáze',
            plot="Procházení a vyhledávání filmů/seriálů v TheMovieDatabase. Vybraný film hledá na Webshare, seriál do Správce seriálů.",
            action='tmdb',
            art_icon=pick_icon(_addon, 'tmdb.png', 'DefaultPicture.png'),
            is_folder=True
        )

        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label='Trakt.tv',
            plot="Procházení Trakt: trendy, populární, kalendář, veřejné seznamy a filtry. Integrovaný scrobbling při přehrávání.",
            action='trakt_menu',
            art_icon=pick_icon(_addon, 'trakt.png', 'DefaultPicture.png'),
            is_folder=True
        )

        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label='ČSFD TOP 300',
            plot="Stažení a procházení TOP 300 filmů a seriálů dle ČSFD, včetně cache detailů a filtrů podle země.",
            action='csfd_toplist',
            art_icon=pick_icon(_addon, 'csfd.png', 'DefaultStar.png'),
            is_folder=True
        )

        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label='TV Program',
            plot="Elektronický program (EPG): Dnes, Zítra, Aktuálně běží a Žánry. Aktualizace EPG po půlnoci při vstupu.",
            action='tvprog_root',
            art_icon=pick_icon(_addon, 'tvprogram.png', 'DefaultCalendar.png'),
            is_folder=True
        )

        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label='Flixpatrol TOP 10',
            plot='TOP 10 z platforem + kalendář premiér (FlixPatrol).',
            action='streaming_report_menu',
            art_icon=pick_icon(_addon, 'flixpatrol.png', 'DefaultCalendar.png'),
            is_folder=True
        )

        add_menu_item(
            handle=_handle, build_url_fn=get_url,
            label=_addon.getLocalizedString(30204),  # "Nastavení"
            plot="Nastavení doplňku — cesty, integrace, chování vyhledávání i TV Programu.",
            action='settings',
            art_icon=pick_icon(_addon, 'settings.png', 'DefaultAddonService.png'),
            is_folder=True
        )
        xbmcplugin.endOfDirectory(_handle)
        return

    # --- centrální mapa akcí (každá jen jednou)
    ACTIONS = {
        # Webshare
        # 'search':      search,
        'refresh_main': lambda p: xbmc.executebuiltin('Container.Refresh'),
        'search': lambda p: search(
            p, _addon, _handle, _profile,
            get_url, api, revalidate, popinfo,
            categories=CATEGORIES, sorts=SORTS, none_placeholder=NONE_WHAT
        ),
        'show_search_dialog': lambda p: (
            xbmc.log(f"[DEBUG] show_search_dialog handler: cz_title='{p.get('cz_title')}', eng_title='{p.get('eng_title')}', year='{p.get('year')}', tmdb_id={p.get('tmdb_id')}, mediatype={p.get('mediatype')}", xbmc.LOGINFO),
            show_search_dialog(
                get_url_fn=get_url,
                cz_title=p.get('cz_title', '').strip(),
                eng_title=p.get('eng_title', '').strip(),
                year=p.get('year', '').strip(),
                tmdb_id=p.get('tmdb_id'),
                mediatype=p.get('mediatype')
            )
        ),
        'toggle_watchlist': lambda p: toggle_watchlist(
        tmdb_id=int(p.get('tmdb_id')) if p.get('tmdb_id') else None
        ),
        'watchlist_list': lambda p: list_watchlist_items(
            get_url, # Předáváme get_url
            _handle, # Předáváme handle
            _addon,  # Předáváme addon
            p        # Předáváme params
        ),
        'queue':       queue,
        'history':     history,
        'settings':    settings,
        'info':        info,
        'play':        play,
        'download':    lambda p: __import__('resources.lib.down.download_manager', fromlist=['download']).download(p),
        'cancel_download': lambda p: (__import__('resources.lib.down.download_manager', fromlist=['cancel_download']).cancel_download(),
                                      xbmcgui.Dialog().notification("Stahování", "Zrušeno uživatelem", xbmcgui.NOTIFICATION_INFO)),
        'db':          db,

        # Series Manager
        'series_filtered': lambda p: (
            __import__('resources.lib.series.series_manager', fromlist=['create_series_menu_filtered']).create_series_menu_filtered(
                series_manager.SeriesManager(_addon, _profile),
                _handle,
                (p.get('status') or 'in_progress').lower()
            )
        ),
        'series_next_episodes': lambda p: (
            __import__('resources.lib.series.series_ui', fromlist=['create_next_episodes_menu']).create_next_episodes_menu(
                series_manager.SeriesManager(_addon, _profile), # Instance SeriesManager
                _handle,                                       # Kodi handle
                _addon,                                        # Kodi addon
                get_url,                                       # Funkce pro generování URL
                _profile                                       # Profil Kodi
            )
        ),
        'series': lambda p: series_menu(p, _addon, _handle, _profile, get_url, api, revalidate, popinfo),
        'series_search': lambda p: series_search(p, _addon, _handle, _profile, get_url, api, revalidate, popinfo),
        'series_detail': lambda p: series_detail(p, _addon, _handle, _profile, get_url, api, revalidate, popinfo),
        'series_season': lambda p: series_season(p, _addon, _handle, _profile, get_url, api, revalidate, popinfo),
        'series_refresh_smart':   lambda p: series_refresh_smart(p, _addon, _handle, _profile, get_url, api, revalidate, popinfo),
        'series_remove': lambda p: series_remove(p, _addon, _handle, _profile, get_url, api, revalidate, popinfo),
        'series_remove_season': lambda p: series_remove_season(p, _addon, _handle, _profile, get_url, api, revalidate, popinfo),
        'series_remove_episode': lambda p: series_remove_episode(p, _addon, _handle, _profile, get_url, api, revalidate, popinfo),
        'series_episode_play':    lambda p: _select_and_play_stream(p.get('series_name',''), p.get('season','1'), p.get('episode','1')),
        'series_mark_season':   lambda p: series_mark_season(p, _addon=_addon, _profile=_profile),
        'series_mark_episode':  lambda p: series_mark_episode(p, _addon=_addon, _profile=_profile),
        # Export seriálů do Kodi knihovny (.strm)
        'series_export_library': lambda p: __import__('resources.lib.library_export', fromlist=['export_series_to_kodi_library']).export_series_to_kodi_library(),
        # Export filmů z playlist.m3u do Kodi knihovny (.strm)
        'movies_export_from_m3u': lambda p: __import__('resources.lib.library_export', fromlist=['export_movies_from_m3u']).export_movies_from_m3u(),
        # Offline stahování (sjednoceno)
        'series_download_season': lambda p: __import__('resources.lib.down.offline_manager', fromlist=['save_season']).save_season(
                                            p.get('series_name',''), p.get('season',''), series_manager.SeriesManager(_addon, _profile)),
        'series_download_episode':lambda p: __import__('resources.lib.down.offline_manager', fromlist=['save_episode']).save_episode(
                                            p.get('series_name',''), str(p.get('season','')), str(p.get('episode','')),
                                            series_manager.SeriesManager(_addon, _profile)),
        'series_download_show':   _download_whole_show,
        'series_csfd_lookup': lambda p: (
            __import__('resources.lib.series.series_actions', fromlist=['csfd_lookup']).csfd_lookup(p.get('series_name'))
        ),
        'csfd_lookup_enhanced': lambda p: csfd_lookup_enhanced(p.get('series_name') or p.get('title') or ''),
        'series_validate_streams': lambda p: _validate_streams_action(p.get('series_name', '')),
        'series_rescan_invalid': lambda p: _rescan_invalid_action(p.get('series_name', '')),
        # --- Series Manager (doplněné) ---
        # Filtr – zobrazí klávesnici (textový filtr)
        'series_streams_list': lambda p: series_manager.list_saved_streams(
            series_manager.SeriesManager(_addon, _profile),
            _handle,
            p.get('series_name'),
            build_url_fn=get_url
        ),

        'diag_series_manager': lambda p: (
            xbmc.log(f"[DIAG] series_manager.__file__ = {__import__('resources.lib.series.series_manager').__file__}", xbmc.LOGINFO),
            xbmc.log(f"[DIAG] SeriesManager methods = {dir(__import__('resources.lib.series.series_manager').SeriesManager)}", xbmc.LOGINFO),
            xbmcgui.Dialog().notification(ADDON_NAME, "DIAG hotovo (viz Kodi log)", xbmcgui.NOTIFICATION_INFO, 3000)
        ),
        # Trakt – hlavní menu/huby/filtry/listingy
        'trakt_menu':          lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).show_main_menu(),
        'trakt_movies_hub':    lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).trakt_movies_hub(),
        'trakt_shows_hub':     lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).trakt_shows_hub(),
        'trakt_lists_hub':     lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).trakt_lists_hub(),
        # 'trakt_movies_filters':lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).movies_filters_wizard(),
        # 'trakt_shows_filters': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).shows_filters_wizard(),
        'trakt_movies_list':   lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).list_movies_by_mode(
                                        p.get('mode','trending'), _safe_int(p.get('page',1),1), _safe_int(p.get('limit',30),30),
                                        p.get('genres') or None, p.get('years') or None),
        'trakt_shows_list':    lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).list_shows_by_mode(
                                        p.get('mode','trending'), _safe_int(p.get('page',1),1), _safe_int(p.get('limit',30),30),
                                        p.get('genres') or None, p.get('years') or None),

        # Trakt – veřejné seznamy
        'trakt_lists_browse':  lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).list_public_lists(
                                        p.get('mode','popular'), _safe_int(p.get('page',1),1), _safe_int(p.get('limit',30),30)),
        'trakt_list_items':    lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).list_items_of_list(
                                        p.get('list_id',''), _safe_int(p.get('page',1),1), _safe_int(p.get('limit',50),50)),

        # Trakt – watched/people/related/calendar/next-last
        'trakt_my_hub': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).show_my_hub(),
        'trakt_watched_movies':lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).list_watched_movies(
                                        page=_safe_int(p.get('page',1),1), limit=_safe_int(p.get('limit',50),50)),
        'trakt_watched_shows': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).list_watched_shows(
                                        url=sys.argv[2], # <<< POUŽITÍ sys.argv[2] MÍSTO p.get('url')
                                        page=_safe_int(p.get('page',1),1), limit=_safe_int(p.get('limit',50),50)),
        'list_watched_shows': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).list_watched_shows(
                                        url=sys.argv[2],
                                        page=_safe_int(p.get('page',1),1), limit=_safe_int(p.get('limit',50),50)),                                        

        'trakt_people':  lambda p: _resolve_trakt_id_and_call('people',  p),
        'trakt_related': lambda p: _resolve_trakt_id_and_call('related', p),
        'trakt_show_next_last':lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).show_next_last_episode(
                                        p.get('id',''), p.get('title','')),
        # 'trakt_people_cache_clear': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['trakt_cache_invalidate_people']).trakt_cache_invalidate_people(
        #                                 p.get('media_type','shows'), p.get('id','')),
        # Watchlist (my) – otevře uživatelský Trakt seznam podle typu
        'trakt_list': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).show_trakt_list(
            p.get('list_type', 'watchlist')
        ),
        # Kalendář (my shows) – nové epizody, volitelné parametry
        'trakt_calendar': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).list_calendar_shows(
            days=int(p.get('days', 30)) if str(p.get('days', '')).isdigit() else 30,
            start_date=p.get('start_date')  # očekává 'YYYY-MM-DD' nebo None
        ),

        # Trakt – auth & status
        'trakt_auth':          lambda p: _trakt_auth_with_status(LOG_PREFIX),
        'trakt_refresh_status':lambda p: _trakt_refresh_status(LOG_PREFIX),


        # Trakt – progress & mazání historie
        'trakt_shows_progress':lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, xbmcaddon.Addon(ADDON_ID)).list_shows_progress(
                                        page=_safe_int(p.get('page',1),1), limit=_safe_int(p.get('limit',30),30),
                                        year=p.get('year',''), mode=p.get('mode','cache'), start_at=p.get('start_at',''),
                                        end_at=p.get('end_at',''), only_incomplete=p.get('only_incomplete','')),
        'trakt_progress_cache_refresh_full_ui': lambda p: __import__('resources.lib.trakt.trakt_service', fromlist=['trakt_progress_cache_refresh_full_ui']).trakt_progress_cache_refresh_full_ui(),
        'trakt_delete_history': _delete_history_prompt_and_refresh,
        'trakt_search_dialog': lambda p: trakt_search_dialog(p), # 🚨 Nová akce!
        'trakt_search_results': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['TraktMenu']).TraktMenu(_handle, _addon).search_trakt(p.get('query')),
        # Trakt – mark watched (sjednocené kanonické názvy + series_* aliasy)
        'trakt_mark_movie':    lambda p: __import__('resources.lib.trakt.trakt_bulk', fromlist=['mark_movie_watched']).mark_movie_watched(_safe_int(p.get('tmdb_id'),0)),
        'trakt_mark_show':     lambda p: __import__('resources.lib.trakt.trakt_bulk', fromlist=['mark_show_watched']).mark_show_watched(_safe_int(p.get('tmdb_id'),0)),
        'trakt_mark_season':   lambda p: __import__('resources.lib.trakt.trakt_bulk', fromlist=['mark_season_watched']).mark_season_watched(_safe_int(p.get('tmdb_id'),0), _safe_int(p.get('season'),0)),
        'trakt_mark_episode':  lambda p: __import__('resources.lib.trakt.trakt_bulk', fromlist=['mark_episode_watched']).mark_episode_watched(_safe_int(p.get('tmdb_id'),0), _safe_int(p.get('season'),0), _safe_int(p.get('episode'),0)),
        'series_trakt_mark_show':    lambda p: __import__('resources.lib.trakt.trakt_bulk', fromlist=['mark_show_watched']).mark_show_watched(_safe_int(p.get('tmdb_id'),0)),
        'series_trakt_mark_season':  lambda p: __import__('resources.lib.trakt.trakt_bulk', fromlist=['mark_season_watched']).mark_season_watched(_safe_int(p.get('tmdb_id'),0), _safe_int(p.get('season'),0)),
        'series_trakt_mark_episode': lambda p: __import__('resources.lib.trakt.trakt_bulk', fromlist=['mark_episode_watched']).mark_episode_watched(_safe_int(p.get('tmdb_id'),0), _safe_int(p.get('season'),0), _safe_int(p.get('episode'),0)),

        # Trakt – PROMPT akce (bez extra kwargs; funkce si vše vyžádá sama)
        'trakt_prompt_mark_season':  lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['trakt_prompt_mark_season']).trakt_prompt_mark_season(
            _safe_int(p.get('tmdb_id'), 0)
        ),
        'trakt_prompt_mark_episode': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['trakt_prompt_mark_episode']).trakt_prompt_mark_episode(
            _safe_int(p.get('tmdb_id'), 0)
        ),
        # --- Trakt: Watchlist ADD/REMOVE (sjednocené akce) ---
        'trakt_watchlist_add': lambda p: __import__('resources.lib.trakt.trakt_watchlist',
                                                    fromlist=['add_to_watchlist']).add_to_watchlist(),
        'trakt_watchlist_remove': lambda p: __import__('resources.lib.trakt.trakt_watchlist',
                                                    fromlist=['remove_from_watchlist']).remove_from_watchlist(),
        'trakt_prompt_filter_watched_shows': lambda p: __import__('resources.lib.utils.ui_utils', fromlist=['prompt_and_filter_list']).prompt_and_filter_list('list_watched_shows', 'title_filter', 'Zadejte počáteční písmena pro filtr historie'),

        # TMDb
        'tmdb':                  lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['show_tmdb_menu']).show_tmdb_menu(),
        'tmdb_search':           lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['tmdb_search_menu']).tmdb_search_menu(),
        'tmdb_list':             lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['show_tmdb_list']).show_tmdb_list(p),
        'tmdb_seasons': lambda p: _tmdb().show_seasons(p.get('tmdb_id'), p.get('title'), p.get('trakt_id'), p.get('slug'), fallback_title=p.get('fallback_title')),
        'tmdb_episodes': lambda p: _tmdb().show_episodes(p.get('tmdb_id'), p.get('season_num'), p.get('title'), p.get('trakt_id'), p.get('slug'), fallback_title=p.get('fallback_title')),        
        'tmdb_movie_categories': lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['show_movie_categories']).show_movie_categories(),
        'tmdb_tv_categories':    lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['show_tv_categories']).show_tv_categories(),
        'tmdb_person_categories': lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['show_person_categories']).show_person_categories(),
        'tmdb_search_person':     lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['tmdb_search_person_menu']).tmdb_search_person_menu(),
        'person_detail':          lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['show_person_detail']).show_person_detail(p),
        'tmdb_person_detail': lambda p: __import__('resources.lib.trakt.trakt_module', fromlist=['show_tmdb_person_detail']).show_tmdb_person_detail(
            int(p.get('tmdb_id', 0))
        ),
        'tmdb_advanced_filter_menu': lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['show_advanced_filter_menu']).show_advanced_filter_menu(),
        'tmdb_discover_list': lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['show_tmdb_discover_list']).show_tmdb_discover_list(p),
        'tmdb_discover_resume': lambda p: __import__('resources.lib.tmdb.tmdb_kodi', fromlist=['tmdb_discover_resume']).tmdb_discover_resume(p),
        'tmdb_audit_fill': lambda p: __import__('resources.lib.utils.background_enrich', fromlist=['background_audit_fill_tmdb_metadata']).background_audit_fill_tmdb_metadata(),
        # ČSFD
        'csfd_toplist':          lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['show_root']).show_root(),
        'csfd_prepare_menu':     lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['prepare_menu']).prepare_menu(),
        'csfd_clean_cache_menu': lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['clean_cache_menu']).clean_cache_menu(),
        'csfd_clean_cache':      lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['clean_cache']).clean_cache(p.get('what','all')),
        'csfd_prepare_all':      lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['prepare_all']).prepare_all((p.get('category','films') or 'films').lower()),
        'csfd_update_all':       lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['update_all']).update_all(),
        'csfd_browse_menu':      lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['browse_menu']).browse_menu((p.get('category','series') or 'series').lower()),
        'csfd_list_countries':   lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['list_countries']).list_countries((p.get('category','series') or 'series').lower()),
        'csfd_browse':           lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['browse']).browse((p.get('category','series') or 'series').lower()),
        'csfd_browse_filtered':  lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['browse_filtered']).browse_filtered(
                                         (p.get('category','series') or 'series').lower(), p.get('countries'), p.get('country')),
        'csfd_prepare_m3u_index':lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['prepare_m3u_index']).prepare_m3u_index(),
        'csfd_play_or_open':     csfd_play_or_open,

        # M3U (sjednoceno; aliasy výše)
        'play_m3u_stream':       lambda p: _play_m3u(p.get('m3u_url','')),
        'show_playlist':         lambda p: __import__('resources.lib.playlist_loader', fromlist=['load_m3u_playlist']).load_m3u_playlist(translatePath(ADDON.getSetting('playlist_path'))),
        # ČSFD — extra filmy z playlistu (mimo Top 300)
        'csfd_extra_playlist': lambda p: __import__('resources.lib.ext.csfd_toplist.router', fromlist=['show_extra_playlist_movies']).show_extra_playlist_movies(p),
        # TV Program (EPG)
        'tvprog_root':           lambda p: (ensure_epg_fresh(), TV.show_root())[1],
        'tvprog_channels':       lambda p: TV.show_channels_by_date(p.get('day')),
        'tvprog_channel':        lambda p: TV.show_channel_programs(p.get('ch'), p.get('day')),
        'tvprog_now':            lambda p: TV.show_now_playing(p.get('day')),
        'tvprog_genres':         lambda p: TV.show_genres(p.get('day')),
        'tvprog_genre':          lambda p: TV.show_programs_by_genre(p.get('day'), p.get('g')),
        'tvprog_info':           lambda p: TV.show_program_info(p.get('ch'), p.get('i') or p.get('idx'), p.get('day')),

        # Fronta stahování
        'queue_menu': lambda p: __import__('resources.lib.down.download_queue', fromlist=['show_queue_menu']).show_queue_menu(),
        'queue_add': lambda p: __import__('resources.lib.down.download_queue', fromlist=['add_to_queue']).add_to_queue(p),
        'queue_remove': lambda p: __import__('resources.lib.down.download_queue', fromlist=['remove_from_queue']).remove_from_queue(p.get('ident')),
        'queue_start': lambda p: __import__('resources.lib.down.download_queue', fromlist=['start_download']).start_download(p.get('ident')),
        'queue_start_all': lambda p: __import__('resources.lib.down.download_queue', fromlist=['start_all']).start_all(),
        'queue_clear': lambda p: __import__('resources.lib.down.download_queue', fromlist=['clear_queue']).clear_queue(),
        'queue_stop_all': lambda p: __import__('resources.lib.down.download_queue', fromlist=['stop_all_downloads']).stop_all_downloads(),
        # 'queue_reset_all': lambda p: __import__('resources.lib.down.download_queue', fromlist=['reset_all_cancelled']).reset_all_cancelled(),

        # FlixPatrol
        'streaming_report_menu':    lambda p: __import__('resources.lib.streaming_report', fromlist=['show_report_menu']).show_report_menu(_handle, get_url),
        'streaming_report_platform':lambda p: __import__('resources.lib.streaming_report', fromlist=['show_platform_titles']).show_platform_titles(_handle, get_url, p.get('p') or 'Netflix'),
        'streaming_report_refresh': lambda p: (__import__('resources.lib.streaming_report', fromlist=['refresh_report']).refresh_report(force=True), xbmc.executebuiltin('Container.Refresh')),

        # Lokální historie (sjednocené helpery)
        'watch_history_list':    _show_watch_history_list_entry,
        'play_history_item':     lambda p: play_history_item(p.get('url'), p.get('tmdb_id'), p.get('media_type')),
        'delete_history_item':   lambda p: delete_history_item(p.get('tmdb_id'), p.get('media_type')),
        # Lokální historie – fix + okamžitý Trakt zápis (lazy import kvůli cyklům)
        'fix_and_scrobble_item': lambda p: (
            __import__('resources.lib.local_history', fromlist=['fix_and_scrobble_item'])
            .fix_and_scrobble_item(int(p.get('index', -1)), (p.get('media_type') or 'movie').lower())
        ),
        'movies_menu': movies_menu,
        # Stažené filmy (modularizace do resources/lib/offline_movie.py)
        'movies_downloaded': lambda p: (
            __import__('resources.lib.down.offline_movie', fromlist=['show_downloaded_movies'])
            .show_downloaded_movies(_handle)
        ),
        'delete_downloaded_file': lambda p: (
            __import__('resources.lib.down.offline_movie', fromlist=['delete_downloaded_file'])
            .delete_downloaded_file(p.get('path',''))
        ),
        'show_folder': lambda p: (
            __import__('resources.lib.down.offline_movie', fromlist=['show_folder'])
            .show_folder(_handle, p.get('path',''))
        ),
           # Webshare VIP
        'ws_refresh_vip':        lambda p: (__import__('resources.lib.webshare_auth', fromlist=['WebshareClient']).WebshareClient(ADDON_ID).refresh_vip_settings(show_toast=True),
                                            xbmcplugin.endOfDirectory(_handle)),
        
        'show_app_log': lambda p: (  # otevře TextViewer s tail(em) logu
            (lambda _tail: __import__('xbmcgui').Dialog().textviewer('Log doplňku', _tail or 'Log je prázdný.'))(
                __import__('resources.lib.utils.app_log', fromlist=['tail']).tail()
            )
        ),
        # Experimentální podmenu a utility
        'exp_menu':          lambda p: show_experimental_menu(),
        'exp_toggle_bool':   lambda p: exp_toggle_bool(p.get('key')),
        'exp_browse_file':   lambda p: exp_b

                                            
        # Trakt -> Webshare search (kanonizováno)
        # 'trakt_search':          lambda p: (search({'action': 'search', 'q': p.get('title','')})) if p.get('title') else (popinfo('Nelze vyhledat Webshare: Chybí název.', icon=xbmcgui.NOTIFICATION_WARNING), xbmcplugin.endOfDirectory(_handle))
    }
    # --- dispatch

    handler = ACTIONS.get(action)
    if handler:
        try:
            handler(params)
        except Exception as e:
            xbmc.log(f"[{LOG_PREFIX}] handler error for action={action}: {e}", xbmc.LOGERROR)
            xbmcgui.Dialog().notification(_addon.getAddonInfo('name'), "Chyba akce.", xbmcgui.NOTIFICATION_ERROR, 3000)
    elif action == 'noop':
        xbmcplugin.endOfDirectory(_handle, succeeded=True)
        return
    else:
        xbmc.log(f"[{LOG_PREFIX}] unknown action: {action}", xbmc.LOGERROR)
        popinfo(f'Neznama akce: {action}', icon=xbmcgui.NOTIFICATION_ERROR)

# --- Sjednocené helpery pro Trakt autorizaci / refresh stavu ---
def _trakt_auth_with_status(LOG_PREFIX="mm.hlavni_router"):
    """Trakt autorizace + update stavu v nastavení (sjednoceno)."""
    xbmc.log(f'[{LOG_PREFIX}] === START Trakt autorizace z nastavení ===', xbmc.LOGDEBUG)
    try:
        from resources.lib.trakt.trakt_service import TraktAPI, update_trakt_status_setting
        TraktAPI().authorize_trakt()
        update_trakt_status_setting()
        xbmcgui.Dialog().notification('Trakt', 'Autorizace dokončena (pokud byla potvrzena na webu).', xbmcgui.NOTIFICATION_INFO, 2500)
    except ValueError as e:
        xbmc.log(f'[{LOG_PREFIX}] TRAKT INIT ERROR: Chybí ID/Secret: {e}', xbmc.LOGERROR)
        xbmcgui.Dialog().notification('Trakt', 'Chybí Client Secret v nastavení.', xbmcgui.NOTIFICATION_ERROR, 3000)
    except ImportError as e:
        xbmc.log(f'[{LOG_PREFIX}] TRAKT CRITICAL ERROR: Nelze importovat Trakt modul: {e}', xbmc.LOGFATAL)
        xbmcgui.Dialog().notification('Chyba Trakt', 'Nelze importovat Trakt modul. Zkontrolujte soubor.', xbmcgui.NOTIFICATION_ERROR, 3000)
    except Exception as e:
        xbmc.log(f'[{LOG_PREFIX}] TRAKT UNEXPECTED ERROR: {e}', xbmc.LOGFATAL)
        xbmcgui.Dialog().notification('Chyba Trakt', 'Nečekaná chyba v autorizaci. Viz log.', xbmcgui.NOTIFICATION_ERROR, 3000)

def _trakt_refresh_status(LOG_PREFIX="mm.hlavni_router"):
    """Aktualizuje textový stav Trakt auth v nastavení (sjednoceno)."""
    try:
        from resources.lib.trakt.trakt_service import update_trakt_status_setting
        update_trakt_status_setting()
        xbmcgui.Dialog().notification('Trakt', 'Stav aktualizován.', xbmcgui.NOTIFICATION_INFO, 1500)
    except Exception as e:
        xbmc.log(f'[{LOG_PREFIX}] trakt_refresh_status error: {e}', xbmc.LOGERROR)
        xbmcgui.Dialog().notification('Trakt', 'Chyba aktualizace stavu.', xbmcgui.NOTIFICATION_ERROR, 3000)


import shutil

def _translate_profile_path():
    """Bezpečně přeloží profil doplňku na lokální cestu."""
    try:
        return xbmcvfs.translatePath(ADDON.getAddonInfo('profile'))
    except Exception:
        # Fallback: některé starší buildy
        try:
            from xbmc import translatePath
            return translatePath(ADDON.getAddonInfo('profile'))
        except Exception:
            return ADDON.getAddonInfo('profile')  # poslední možnost (může být special://...)


def get_storage_info():
    """
    Vrátí (free_gb, total_gb) pomocí shutil.disk_usage().
    Funguje na Windows/Linux/macOS/Android.
    """
    try:
        profile_path = _translate_profile_path()
        usage = shutil.disk_usage(profile_path)
        free_gb = round(usage.free / (1024**3), 2)
        total_gb = round(usage.total / (1024**3), 2)
        return free_gb, total_gb
    except Exception as e:
        xbmc.log(f"[storage_info] disk_usage failed: {e}", xbmc.LOGWARNING)
        return 0.0, 0.0


def _size_os_walk(root_path: str) -> int:
    """Rychlá varianta: spočítá velikost pomocí os.walk; může selhat na některých VFS cestách."""
    try:
        total = 0
        for r, dnames, fnames in os.walk(root_path):
            for fn in fnames:
                fp = os.path.join(r, fn)
                try:
                    total += os.path.getsize(fp)
                except Exception:
                    # ignoruj nedostupné/locknuté soubory
                    pass
        return total
    except Exception as e:
        xbmc.log(f"[addon_data_size] os.walk failed: {e}", xbmc.LOGINFO)
        return -1  # signalizuj, že je potřeba fallback


def _size_vfs_recursive(root_path: str) -> int:
    """
    Fallback varianta: spočítá velikost rekurzí přes Kodi VFS (xbmcvfs).
    Vhodné pro Android/scoped storage nebo special://profile.
    """
    total = 0
    try:
        # xbmcvfs.listdir vrací (dirs, files) relativně k root_path
        dirs, files = xbmcvfs.listdir(root_path)
        # Files v kořeni
        for f in files:
            fp = os.path.join(root_path, f)
            try:
                st = xbmcvfs.Stat(fp)
                # některé buildy mají st_size jako callable
                if hasattr(st, "st_size"):
                    size_attr = getattr(st, "st_size")
                    size = int(size_attr() if callable(size_attr) else size_attr)
                else:
                    # fallback na os.path.getsize, pokud translatePath vrací skutečnou cestu
                    size = os.path.getsize(fp)
                total += max(size, 0)
            except Exception:
                # když Stat selže, zkus os.path.getsize
                try:
                    total += os.path.getsize(fp)
                except Exception:
                    pass

        # Rekurzivně do podadresářů
        for d in dirs:
            sub = os.path.join(root_path, d)
            total += _size_vfs_recursive(sub)
    except Exception as e:
        xbmc.log(f"[addon_data_size] vfs recursion failed at {root_path}: {e}", xbmc.LOGWARNING)
    return total


def get_addon_data_size_mb():
    """
    Vrátí velikost složky addon_data (včetně podsložek) v MB.
    Cross‑platform:
      - nejdřív zkus os.walk (rychlejší, kde je podporován),
      - pokud selže, spočítej přes Kodi VFS rekurzí.
    """
    try:
        profile_path = _translate_profile_path()
        total_bytes = _size_os_walk(profile_path)
        if total_bytes < 0:  # fallback přes VFS
            total_bytes = _size_vfs_recursive(profile_path)
        return round(total_bytes / (1024 * 1024), 1)
    except Exception as e:
        xbmc.log(f"[addon_data_size] failed: {e}", xbmc.LOGERROR)

def _validate_streams_action(series_name):
    import importlib
    from resources.lib.series import series_manager
    importlib.reload(series_manager)  # vynucený reload modulu

    sm = series_manager.SeriesManager(_addon, _profile)
    token = revalidate()

    # Volání s keyword args pro jistotu
    result = sm.validate_series_streams(
        series_name=series_name,
        api_fn=api,
        token=token
    )

    # Výstup s deduplikací chyb
    msg = f"OK: {result['ok']} • Neplatné: {result['invalid']}"
    if result['invalid'] > 0:
        uniq = []
        for s in result.get('errors', []):
            if s not in uniq:
                uniq.append(s)
        preview = ", ".join(uniq[:10])
        msg += f"\nNeplatné epizody: {preview}"
        if len(uniq) > 10:
            msg += f" … (+{len(uniq) - 10} dalších)"
    xbmcgui.Dialog().ok("Kontrola streamů", msg)

    # Nabídka rescan (pokud jsou epizody)
    if result.get('rescan'):
        if xbmcgui.Dialog().yesno("Rescan", f"Chcete znovu vyhledat {len(result['rescan'])} epizod s neplatnými streamy?"):
            _rescan_invalid_action(series_name)


def _rescan_invalid_action(series_name):
    
    sm = series_manager.SeriesManager(_addon, _profile)
    data = sm.load_series_data(series_name)
    xbmc.log(f"[DEBUG] bound search_series: {sm.search_series}", xbmc.LOGINFO)
    if not data:
        xbmcgui.Dialog().notification(ADDON_NAME, "Data seriálu nenalezena", xbmcgui.NOTIFICATION_ERROR)
        return

    invalid_eps = []
    for s_key, season in (data.get("seasons") or {}).items():
        for e_key, ep in (season or {}).items():
            if not ep.get("streams"):
                invalid_eps.append((s_key, e_key))

    if not invalid_eps:
        xbmcgui.Dialog().notification(ADDON_NAME, "Žádné epizody k rescan", xbmcgui.NOTIFICATION_INFO)
        return

    token = revalidate()
    for s_key, e_key in invalid_eps:
        xbmc.log(f"[Rescan] S{s_key}E{e_key}", xbmc.LOGINFO)
        # Znovu vyhledat epizodu přes search_series (můžeš volat sm.search_series s parametry)
        sm.search_series(data.get("name"), api, token)

    xbmcgui.Dialog().notification(ADDON_NAME, f"Rescan dokončen ({len(invalid_eps)} epizod)", xbmcgui.NOTIFICATION_INFO)

# === BACKGROUND ENRICHER – spustí se jednou po startu doplňku ===
try:
    import resources.lib.utils.background_enrich
except Exception as e:
    xbmc.log(f"[V2] Background enrich import selhal: {e}", xbmc.LOGWARNING)