# scrobble_delay.py - FINÁLNÍ OPRAVENÁ VERZE (spoleh na ListItem.Property + delší timeout)
import sys
import os
import xbmc
import xbmcaddon
import urllib.parse
import json
# Pokud je payload už zamknutý, končíme (už byl spuštěn z play())
addon = xbmcaddon.Addon('plugin.video.mmirousek_v2')
if addon.getSetting('trakt_payload_locked') == 'true':
    xbmc.log('########## SCROBBLE DELAY: Payload už zamknutý – končím (již spuštěno z play()) ##########', xbmc.LOGINFO)
    sys.exit(0)
    
try:
    if len(sys.argv) < 3:
        raise ValueError("Chybí argument cesty k addonu.")
   
    __addon_path__ = urllib.parse.unquote_plus(sys.argv[2])
    scrobble_lib_path = os.path.join(__addon_path__, 'resources', 'lib')
    sys.path.append(scrobble_lib_path)
   
    from scrobble import scrobble_start, build_payload_from_id 
    xbmc.log(f'########## SCROBBLE DELAY: Import OK, cesta: {scrobble_lib_path} ##########', xbmc.LOGINFO)
   
except Exception as e:
    xbmc.log(f'########## SCROBBLE DELAY: CHYBA IMPORTU: {e} ##########', xbmc.LOGERROR)
    sys.exit(1)

MAX_WAIT_SECONDS = 20  # Zvýšeno na 20 sekund – u Webshare streamů to někdy trvá déle

for i in range(MAX_WAIT_SECONDS):
    
    tmdb_id = None
    mediatype = None
    
    # 1. Pokus o načtení z URL (pro úplnost, pokud by někdy fungovalo správně)
    if len(sys.argv) > 2:
        current_url = urllib.parse.unquote_plus(sys.argv[2])
        parsed = urllib.parse.urlparse(current_url)
        query_params = urllib.parse.parse_qs(parsed.query)
        url_tmdb = query_params.get('tmdb_id', [None])[0]
        url_media = query_params.get('mediatype', [None])[0]
        if url_tmdb and url_media:
            tmdb_id = url_tmdb
            mediatype = url_media
            xbmc.log(f"########## SCROBBLE DELAY: Načteno z URL → tmdb_id={tmdb_id}, mediatype={mediatype} ##########", xbmc.LOGINFO)

    # 2. Hlavní fallback: ListItem.Property (opakovaně – Kodi ho někdy nastaví až po chvíli)
    if not tmdb_id or not mediatype:
        list_tmdb = xbmc.getInfoLabel('ListItem.Property(tmdb_id)')
        list_media = xbmc.getInfoLabel('ListItem.Property(mediatype)')
        if list_tmdb and list_tmdb not in ('', '0'):
            tmdb_id = list_tmdb
        if list_media:
            mediatype = list_media
        xbmc.log(f"########## SCROBBLE DELAY: Pokus {i+1}/{MAX_WAIT_SECONDS} – ListItem → tmdb_id={tmdb_id}, mediatype={mediatype} ##########", xbmc.LOGINFO)

    # 3. Pokud máme platné ID, pokračujeme
    if tmdb_id and mediatype and tmdb_id not in ('', '0'):
        xbmc.log(f'########## SCROBBLE DELAY: Spolehlivé ID NALEZENO po {i+1} pokusech: TMDB={tmdb_id}, Typ={mediatype} ##########', xbmc.LOGINFO)
       
        payload = build_payload_from_id(tmdb_id, mediatype)
        
        if payload:
            try:
                addon = xbmcaddon.Addon('plugin.video.mmirousek_v2')
                
                addon.setSetting('trakt_last_payload', json.dumps(payload))
                addon.setSetting('trakt_payload_locked', 'true')
                
                xbmc.log('########## SCROBBLE DELAY: Payload ULOŽEN + ZAMKNUT. Startuji scrobble_start(). ##########', xbmc.LOGINFO)
                scrobble_start()

                sys.exit(0)
            except Exception as e:
                xbmc.log(f'########## SCROBBLE DELAY: CHYBA ZAMYKÁNÍ/STARTU: {e} ##########', xbmc.LOGERROR)
                sys.exit(1)
        else:
            xbmc.log(f'########## SCROBBLE DELAY: Payload NELZE SESTAVIT pro ID {tmdb_id}. ##########', xbmc.LOGWARNING)
            sys.exit(1)

    xbmc.sleep(1000)

# Timeout vypršel
xbmc.log(f'########## SCROBBLE DELAY: Spolehlivé ID nenalezeno ani po {MAX_WAIT_SECONDS}s, vzdávám se. ##########', xbmc.LOGWARNING)
sys.exit(1)