
# -*- coding: utf-8 -*-
import xbmc
import xbmcaddon
import xbmcgui
import sys
import os
import xbmcvfs
import urllib.parse
import time
from datetime import datetime

ADDON_ID = 'plugin.video.mmirousek'

# Guard proti více instancím
try:
    win = xbmcgui.Window(10000)
    if win.getProperty('mm_scrobble_service_running') == '1':
        xbmc.log('[Service] Už běží – ukončuji druhý start', xbmc.LOGINFO)
        sys.exit(0)
    win.setProperty('mm_scrobble_service_running', '1')
    xbmc.log('[Service] Guard OK', xbmc.LOGINFO)
except Exception as e:
    xbmc.log(f'[Service] Guard property error: {e}', xbmc.LOGWARNING)

try:
    __addon__ = xbmcaddon.Addon(ADDON_ID)
    __addon_path__ = xbmcvfs.translatePath(__addon__.getAddonInfo('path'))
    sys.path.append(os.path.join(__addon_path__, 'resources', 'lib'))
    from scrobble import scrobble_stop, scrobble_pause
    from resources.lib.download_queue import load_queue, start_all, stop_all_downloads
    xbmc.log('##### SERVICE.PY BĚŽÍ #####', xbmc.LOGINFO)
except Exception as e:
    xbmc.log(f'[Service] FATÁLNÍ CHYBA při importu: {e}', xbmc.LOGERROR)
    sys.exit(1)

# --- Pomocné funkce ---
def in_time_window(start_str, end_str):
    try:
        now = datetime.now().time()
        sh, sm = map(int, start_str.split(':'))
        eh, em = map(int, end_str.split(':'))
        start_t = datetime.now().replace(hour=sh, minute=sm, second=0).time()
        end_t = datetime.now().replace(hour=eh, minute=em, second=0).time()
        return (start_t <= now <= end_t) if start_t <= end_t else (now >= start_t or now <= end_t)
    except Exception:
        return False

def _set_auto_session(active: bool):
    try:
        xbmcgui.Window(10000).setProperty('mm_auto_dl_session', '1' if active else '')
        xbmc.log(f"[AutoDownload] session={'ON' if active else 'OFF'}", xbmc.LOGDEBUG)
    except Exception:
        pass

def _is_auto_session() -> bool:
    try:
        return xbmcgui.Window(10000).getProperty('mm_auto_dl_session') == '1'
    except Exception:
        return False

def _any_downloading() -> bool:
    try:
        q = load_queue() or []
        return any((i or {}).get('status') == 'downloading' for i in q)
    except Exception:
        return False

def _any_pending() -> bool:
    try:
        q = load_queue() or []
        return any((i or {}).get('status') == 'pending' for i in q)
    except Exception:
        return False

# --- Player monitor pro scrobble ---
class PlayerMonitor(xbmc.Player):
    def __init__(self):
        super().__init__()
        xbmc.log('##### PlayerMonitor Inicializován #####', xbmc.LOGINFO)

    def onPlayBackStarted(self):
        xbmc.log('[Service] onPlayBackStarted – spouštím scrobble_delay.py', xbmc.LOGINFO)
        script_path = os.path.join(__addon_path__, 'scrobble_delay.py')
        encoded_path = urllib.parse.quote_plus(__addon_path__)
        xbmc.executebuiltin(f'RunScript("{script_path}",1,"{encoded_path}")')

    def onPlayBackStopped(self):
        xbmc.log('[Service] onPlayBackStopped – scrobble_stop', xbmc.LOGINFO)
        scrobble_stop()

    def onPlayBackPaused(self):
        scrobble_pause()

# --- Hlavní smyčka ---
if __name__ == '__main__':
    player_monitor = PlayerMonitor()
    monitor = xbmc.Monitor()
    last_auto_check = 0
    xbmc.log('[Service] Hlavní smyčka start', xbmc.LOGINFO)

    try:
        while not monitor.abortRequested():
            try:
                # --- SCROBBLE UPDATE ---
                from resources.lib.scrobble import _update_progress
                _update_progress()

                # --- AUTO DOWNLOAD každých 5 minut ---
                now_ts = time.time()
                if now_ts - last_auto_check >= 300:  # 5 minut
                    last_auto_check = now_ts
                    enable_auto = __addon__.getSettingBool('enable_auto_download')
                    start_time = __addon__.getSetting('auto_download_start') or '22:00'
                    end_time   = __addon__.getSetting('auto_download_end')   or '06:00'
                    in_window  = in_time_window(start_time, end_time)

                    xbmc.log(f"[AutoDownload] enable={enable_auto}, window={start_time}-{end_time}, in_window={in_window}", xbmc.LOGDEBUG)

                    if not enable_auto:
                        if _is_auto_session():
                            xbmc.log("[AutoDownload] Disable detected → clearing session", xbmc.LOGINFO)
                            _set_auto_session(False)
                    else:
                        if in_window:
                            if _any_pending() and not _any_downloading():
                                xbmc.log("[AutoDownload] Starting queue (in window)", xbmc.LOGINFO)
                                xbmcgui.Dialog().notification("AutoDownload", "Automatické stahování zahájeno", xbmcgui.NOTIFICATION_INFO, 2500)
                                _set_auto_session(True)
                                start_all()
                        else:
                            if _is_auto_session() and _any_downloading():
                                xbmc.log("[AutoDownload] Outside window → stopping auto session downloads", xbmc.LOGINFO)
                                stop_all_downloads()
                                xbmcgui.Dialog().notification("AutoDownload", "Stahování ukončeno mimo časové okno", xbmcgui.NOTIFICATION_WARNING, 2500)
                                _set_auto_session(False)
                            elif _is_auto_session():
                                xbmc.log("[AutoDownload] Outside window and no downloading → clearing session", xbmc.LOGDEBUG)
                                _set_auto_session(False)

                if monitor.waitForAbort(1):
                    break
            except Exception as e:
                xbmc.log(f'[Service] Tik chyba: {e}', xbmc.LOGWARNING)

    finally:
        try:
            xbmcgui.Window(10000).setProperty('mm_scrobble_service_running', '')
        except Exception:
            pass
        xbmc.log('##### SERVICE UKONČEN #####', xbmc.LOGINFO)
