import xbmc
import xbmcgui
import xbmcplugin
import sys
import os
import re
import xbmcaddon
import xbmcvfs

_handle = int(sys.argv[1])

def get_playlist_path():
    addon = xbmcaddon.Addon(id="plugin.video.mmirousek")
    addon_path = addon.getAddonInfo("path")
    return xbmcvfs.translatePath(addon_path + "/resources/media/playlist.m3u")

def load_m3u_playlist(filepath):
    addon = xbmcaddon.Addon(id="plugin.video.mmirousek")
    addon_path = addon.getAddonInfo("path")
    playlist_path = xbmcvfs.translatePath(addon_path + "/resources/media/playlist.m3u")
    # použij defaultní cestu, pokud není předána jiná
    filepath = filepath or playlist_path
    if not os.path.isfile(filepath):
        xbmc.log(f"[M3U] Soubor nenalezen: {filepath}", level=xbmc.LOGERROR)
        xbmcgui.Dialog().ok("Chyba", f"Soubor nenalezen:\n{filepath}")
        return

    xbmc.log(f"[M3U] Načítám playlist: {filepath}", level=xbmc.LOGINFO)

    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            lines = f.readlines()
    except Exception as e:
        xbmc.log(f"[M3U] Chyba při čtení souboru: {e}", level=xbmc.LOGERROR)
        xbmcgui.Dialog().notification("M3U Playlist", "Chyba při čtení souboru.", xbmcgui.NOTIFICATION_ERROR)
        return

    items = []
    for i in range(len(lines)):
        if lines[i].startswith('#EXTINF'):
            info_line = lines[i]
            m3u_url = lines[i + 1].strip()

            title_match = re.search(r',(.*)', info_line)
            title = title_match.group(1).strip() if title_match else 'Neznámý název'

            logo_match = re.search(r'tvg-logo="([^"]+)"', info_line)
            logo = logo_match.group(1) if logo_match else None

            group_match = re.search(r'group-title="([^"]+)"', info_line)
            group = group_match.group(1) if group_match else None

            items.append({
                'title': title,
                'm3u_url': m3u_url,
                'logo': logo,
                'group': group
            })

    xbmc.log(f"[M3U] Načteno položek: {len(items)}", level=xbmc.LOGINFO)

    for item in items:
        listitem = xbmcgui.ListItem(label=item['title'])
        listitem.setProperty('IsPlayable', 'true')
        if item['logo']:
            listitem.setArt({'thumb': item['logo'], 'icon': item['logo']})
        if item['group']:
            listitem.setInfo('video', {'genre': item['group']})

        play_url = f"{sys.argv[0]}?action=play_m3u_stream&m3u_url={item['m3u_url']}"
        xbmcplugin.addDirectoryItem(_handle, play_url, listitem, False)

    xbmcplugin.endOfDirectory(_handle)

def play_m3u_stream(m3u_url, handle=None):
    import xbmc
    import xbmcgui
    import xbmcplugin
    import sys

    xbmc.log(f"[DEBUG] Typ proměnné m3u_url: {type(m3u_url)}", level=xbmc.LOGINFO)
    xbmc.log(f"[DEBUG] Délka m3u_url: {len(m3u_url) if isinstance(m3u_url, str) else '??'}", level=xbmc.LOGINFO)
    xbmc.log(f"[DEBUG] Obsah m3u_url: {repr(m3u_url)}", level=xbmc.LOGINFO)

    if not m3u_url:
        xbmc.log("[M3U] Chybí URL streamu.", level=xbmc.LOGERROR)
        xbmcgui.Dialog().notification("M3U Playlist", "Chybí URL streamu.", xbmcgui.NOTIFICATION_ERROR)
        return

    # 1) Zjisti aktuální handle – prioritně nás zajímá ten, který předáme z yawsp.py
    current_handle = None
    try:
        if handle is not None:
            current_handle = int(handle)
        elif len(sys.argv) > 1:
            current_handle = int(sys.argv[1])
    except Exception:
        current_handle = None

    xbmc.log(f"[M3U] play_m3u_stream: použiju handle={current_handle}", level=xbmc.LOGINFO)

    try:
        li = xbmcgui.ListItem(path=m3u_url)
        li.setProperty('IsPlayable', 'true')
        li.setContentLookup(False)

        # 2) Primárně zkus resolver (správná cesta při kliknutí na nepřehrávaný item)
        if current_handle is not None and current_handle >= 0:
            xbmcplugin.setResolvedUrl(current_handle, True, li)
            return

        # 3) Fallback: když nemáme validní handle, přehraj přímo
        xbmc.log("[M3U] Resolver nemá validní handle – pouštím přes xbmc.Player().play()", level=xbmc.LOGINFO)
        xbmc.Player().play(item=m3u_url, listitem=li)

    except Exception as e:
        xbmc.log(f"[M3U] Chyba při přehrávání: {e}", level=xbmc.LOGERROR)
        xbmcgui.Dialog().notification("M3U Playlist", f"Přehrávání selhalo:\n{str(e)}", xbmcgui.NOTIFICATION_ERROR)